% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlate_gene_expression.R
\name{getFunctionalGenes}
\alias{getFunctionalGenes}
\title{The getFunctionalGenes function}
\usage{
getFunctionalGenes(
  target.probe,
  target.genes,
  MET_matrix,
  gene.expression.data,
  ProbeAnnotation,
  correlation = "negative",
  raw.pvalue.threshold = 0.05,
  adjusted.pvalue.threshold = 0.01
)
}
\arguments{
\item{target.probe}{character string indicating the probe to be evaluated.}

\item{target.genes}{character vector indicating the nearby genes of the target probe.}

\item{MET_matrix}{methylation data matrix for CpGs from group.1 and group.2.}

\item{gene.expression.data}{gene expression data matrix.}

\item{ProbeAnnotation}{GRange object of CpG probe annotation.}

\item{raw.pvalue.threshold}{raw p value from testing DNA methylation and gene expression}

\item{adjusted.pvalue.threshold}{adjusted p value from testing DNA methylation and gene expression}
}
\value{
dataframe with functional probe-gene pair and p values from the Wilcoxon test for methylation and gene expression.
}
\description{
Helper function to assess if the methylation of a probe is reversely correlated with the expression of its nearby genes.
}
\details{
This function is probe-centered, which is used in the enhancer mode and the miRNA mode of EpiMix.
}
\examples{
\donttest{
data(Sample_EpiMixResults_Enhancer)
data(mRNA.data)
EpiMixResults <- Sample_EpiMixResults_Enhancer
target.probe <- EpiMixResults$FunctionalPairs$Probe[1]
target.genes <- EpiMixResults$FunctionalPairs$Gene
MET_matrix <- EpiMixResults$MethylationStates
ProbeAnnotation <- ExperimentHub::ExperimentHub()[["EH3675"]]
res <- getFunctionalGenes(target.probe, target.genes, MET_matrix, mRNA.data, ProbeAnnotation)
}

}
\keyword{internal}
