% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_chromHMM_annotation.R
\name{get_chromHMM_annotation}
\alias{get_chromHMM_annotation}
\title{Download ChromHMM annotation file(s)}
\usage{
get_chromHMM_annotation(
  cell_line,
  cache = BiocFileCache::BiocFileCache(ask = FALSE)
)
}
\arguments{
\item{cell_line}{ChromHMM annotation for user-specified cell-line.
Cell-line options are:
\itemize{
  \item "K562" = K-562 cells
  \item "Gm12878" = Cellosaurus cell-line GM12878
  \item "H1hesc" = H1 Human Embryonic Stem Cell
  \item "Hepg2" = Hep G2 cell
  \item "Hmec" = Human Mammary Epithelial Cell
  \item "Hsmm" = Human Skeletal Muscle Myoblasts
  \item "Huvec" = Human Umbilical Vein Endothelial Cells
  \item "Nhek" = Normal Human Epidermal Keratinocytes
  \item "Nhlf" = Normal Human Lung Fibroblasts
}}
}
\value{
Cell-line specific ChromHMM annotation file. Default K562 cell-line.
}
\description{
Download ChromHMM annotation file(s) for a given cell-line
 (returned as a \link[GenomicRanges]{GRanges} object) 
 or a list of cell-lines
 (returned as a named list of \link[GenomicRanges]{GRanges} objects).
 All annotations are aligned to the hg19 genome build.
 All data can be found on the UCSC Genome Browser 
 \href{https://hgdownload.cse.ucsc.edu/goldenPath/hg19/encodeDCC/wgEncodeBroadHmm/}{
 here}.
}
\keyword{internal}
