% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap_heatmap.R
\name{overlap_heatmap}
\alias{overlap_heatmap}
\title{Generate heatmap of percentage overlap}
\usage{
overlap_heatmap(
  peaklist,
  interact = TRUE,
  draw_cellnote = TRUE,
  fill_diag = NA,
  verbose = TRUE
)
}
\arguments{
\item{peaklist}{A list of peak files as GRanges object.
Files must be listed and named using \code{list()}.
e.g. \code{list("name1"=file1, "name2"=file2)}.
If not named, default file names will be assigned.}

\item{interact}{Default TRUE. By default heatmap is interactive.
If FALSE, heatmap is static.}

\item{draw_cellnote}{Draw the numeric values within each heatmap cell.}

\item{fill_diag}{Fill the diagonal of the overlap matrix.}

\item{verbose}{Print messages.}
}
\value{
An interactive heatmap
}
\description{
This function generates a heatmap showing percentage of overlapping peaks
between peak files.
}
\examples{
### Load Data ###
data("encode_H3K27ac") # example peakfile GRanges object
data("CnT_H3K27ac") # example peakfile GRanges object
### Create Named List ###
peaklist <- list("encode"=encode_H3K27ac, "CnT"=CnT_H3K27ac)
### Run ###
my_heatmap <- overlap_heatmap(peaklist = peaklist) 
}
