% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpiCompare.R
\name{EpiCompare}
\alias{EpiCompare}
\title{Compare epigenomic datasets}
\usage{
EpiCompare(
  peakfiles,
  genome_build,
  genome_build_output = "hg19",
  blacklist = NULL,
  picard_files = NULL,
  reference = NULL,
  peak_score_plot = FALSE,
  upset_plot = FALSE,
  stat_plot = FALSE,
  chromHMM_plot = FALSE,
  chromHMM_annotation = "K562",
  chipseeker_plot = FALSE,
  enrichment_plot = FALSE,
  tss_plot = FALSE,
  tss_distance = c(-3000, 3000),
  precision_recall_plot = FALSE,
  n_threshold = 20,
  corr_plot = FALSE,
  bin_size = 5000,
  interact = TRUE,
  add_download_button = FALSE,
  save_output = FALSE,
  output_filename = "EpiCompare",
  output_timestamp = FALSE,
  output_dir,
  display = NULL,
  run_all = FALSE,
  workers = 1,
  quiet = FALSE,
  error = FALSE,
  debug = FALSE
)
}
\arguments{
\item{peakfiles}{A list of peak files as GRanges object and/or as paths to
BED files. If paths are provided, EpiCompare imports the file as GRanges
object. EpiCompare also accepts a list containing a mix of GRanges objects
and paths.Files must be listed and named using \code{list()}.
E.g. \code{list("name1"=file1, "name2"=file2)}. If no names are specified,
default file names will be assigned.}

\item{genome_build}{A named list indicating the genome build used to
generate each of the following inputs:
\itemize{
\item{"peakfiles" : }{Genome build for the \code{peakfiles} input.
Assumes genome build is the same for each element in the \code{peakfiles}
list.}
\item{"reference" : }{Genome build for the \code{reference} input.}
\item{"blacklist" : }{Genome build for the \code{blacklist} input.}
}
Example input list:\cr
 \code{genome_build = list(peakfiles="hg38",
 reference="hg19", blacklist="hg19")}\cr\cr
Alternatively, you can supply a single character string instead of a list.
This should \emph{only} be done in situations where all three inputs
(\code{peakfiles}, \code{reference}, \code{blacklist}) are of the same
genome build. For example:\cr
\code{genome_build = "hg19"}\cr\cr
Supported genome builds are: "hg19", "hg38", "mm9" and "mm10".}

\item{genome_build_output}{Genome build to standardise all inputs to.
Liftovers will be performed automatically as needed.
Default: "hg19".\cr\cr
\strong{Note:} Cross-species liftovers are supported.}

\item{blacklist}{A \link[GenomicRanges]{GRanges} object
 containing blacklisted genomic regions.
Blacklists included in \pkg{EpiCompare} are:
\itemize{
\item{\code{NULL} (default): }{Automatically selects the appropriate
 blacklist based on the \code{genome_build_output} argument.}
\item{"hg19_blacklist": }{Regions of hg19 genome that have anomalous
and/or unstructured signals. \link[EpiCompare]{hg19_blacklist}}
\item{"hg38_blacklist": }{Regions of hg38 genome that have anomalous
and/or unstructured signals. \link[EpiCompare]{hg38_blacklist}}
\item{"mm10_blacklist": }{Regions of mm10 genome that have anomalous
and/or unstructured signals. \link[EpiCompare]{mm10_blacklist}}
\item{"mm9_blacklist": }{Blacklisted regions of mm10 genome that have been
 lifted over from \link[EpiCompare]{mm10_blacklist}.
 \link[EpiCompare]{mm9_blacklist}}
\item{\code{<user_input>}: }{A custom user-provided blacklist in
\link[GenomicRanges]{GRanges} format.}
}}

\item{picard_files}{A list of summary metrics output from Picard.
Files must be in data.frame format and listed using \code{list()}
and named using \code{names()}.
To import Picard duplication metrics (.txt file)
 into R as data frame, use:\cr
\code{picard <- read.table("/path/to/picard/output",
 header = TRUE, fill = TRUE)}.}

\item{reference}{A named list containing reference peak file(s) as GRanges
 object. Please ensure that the reference file is listed and named
i.e. \code{list("reference_name" = reference_peak)}. If more than one
reference is specified, individual reports for each reference will be
generated. However, please note that specifying more than one reference can
take awhile. If a reference is specified, it enables two analyses: (1) plot
showing statistical significance of overlapping/non-overlapping peaks; and
(2) ChromHMM of overlapping/non-overlapping peaks.}

\item{peak_score_plot}{Default FALSE. If TRUE, the report includes boxplots
showing the distribution of peak scores in each peak file.}

\item{upset_plot}{Default FALSE. If TRUE, the report includes upset plot of
overlapping peaks.}

\item{stat_plot}{Default FALSE. If TRUE, the function creates a plot showing
the statistical significance of overlapping/non-overlapping peaks.
Reference peak file must be provided.}

\item{chromHMM_plot}{Default FALSE. If TRUE, the function outputs ChromHMM
heatmap of individual peak files. If a reference peak file is provided,
ChromHMM annotation of overlapping and non-overlapping peaks
is also provided.}

\item{chromHMM_annotation}{ChromHMM annotation for ChromHMM plots.
Default K562 cell-line. Cell-line options are:
\itemize{
  \item "K562" = K-562 cells
  \item "Gm12878" = Cellosaurus cell-line GM12878
  \item "H1hesc" = H1 Human Embryonic Stem Cell
  \item "Hepg2" = Hep G2 cell
  \item "Hmec" = Human Mammary Epithelial Cell
  \item "Hsmm" = Human Skeletal Muscle Myoblasts
  \item "Huvec" = Human Umbilical Vein Endothelial Cells
  \item "Nhek" = Normal Human Epidermal Keratinocytes
  \item "Nhlf" = Normal Human Lung Fibroblasts
}}

\item{chipseeker_plot}{Default FALSE. If TRUE, the report includes a barplot
of ChIPseeker annotation of peak files.}

\item{enrichment_plot}{Default FALSE. If TRUE, the report includes dotplots
of KEGG and GO enrichment analysis of peak files.}

\item{tss_plot}{Default FALSE. If TRUE, the report includes peak count
frequency around transcriptional start site. Note that this can take awhile.}

\item{tss_distance}{A vector specifying the distance upstream and downstream
around transcription start sites (TSS). 
The default value is \code{c(-3000,3000)}; meaning peak frequency 
3000bp upstream and downstream of TSS will be displayed.}

\item{precision_recall_plot}{Default is FALSE. If TRUE,
creates a precision-recall curve plot and an F1 plot using
\link[EpiCompare]{plot_precision_recall}.}

\item{n_threshold}{Number of thresholds to test.}

\item{corr_plot}{Default is FALSE. If TRUE, creates a correlation plot across
all peak files using
\link[EpiCompare]{plot_corr}.}

\item{bin_size}{Default of 100. Base-pair size of the bins created to measure
correlation. Use smaller value for higher resolution but longer run time and 
larger memory usage.}

\item{interact}{Default TRUE. By default, plots are interactive.
If set FALSE, all plots in the report will be static.}

\item{add_download_button}{Add download buttons for each plot or dataset.}

\item{save_output}{Default FALSE. If TRUE, all outputs (tables and plots) of
the analysis will be saved in a folder (EpiCompare_file).}

\item{output_filename}{Default EpiCompare.html. If otherwise, the html report
will be saved in the specified name.}

\item{output_timestamp}{Default FALSE. If TRUE, date will be included in the
file name.}

\item{output_dir}{Path to where output HTML file should be saved.}

\item{display}{After completion, automatically display the HTML report file
 in one of the following ways:
\itemize{
\item{"browser" : }{Display the report in your default web browser.}
\item{"rsstudio" : }{Display the report in Rstudio.}
\item{NULL (default) : }{Do not display the report.}
}}

\item{run_all}{Convenience argument that enables all plots/features
(without specifying each argument manually)
 by overriding the default values.
 Default: \code{FALSE}.}

\item{workers}{Number of threads to parallelize across.}

\item{quiet}{An option to suppress printing during rendering from knitr,
pandoc command line and others. To only suppress printing of the last
"Output created: " message, you can set \code{rmarkdown.render.message} to
\code{FALSE}}

\item{error}{If \code{TRUE}, the Rmarkdown report will continue to render
even when some chunks encounter errors (default: \code{FALSE}).
Passed to \link[knitr]{opts_chunk}.}

\item{debug}{Run in debug mode, where are messages and warnings
are printed within the HTML report (default: \code{FALSE}).}
}
\value{
Path to one or more HTML report files.
}
\description{
This function compares and analyses multiple epigenomic datasets and outputs
an HTML report containing all results of the analysis. The report is mainly
divided into three sections: (1) General Metrics on Peakfiles,
(2) Peak Overlaps and (3) Functional Annotation of Peaks.
}
\examples{
### Load Data ###
data("encode_H3K27ac") # example dataset as GRanges object
data("CnT_H3K27ac") # example dataset as GRanges object
data("CnR_H3K27ac") # example dataset as GRanges object
data("CnT_H3K27ac_picard") # example Picard summary output
data("CnR_H3K27ac_picard") # example Picard summary output

#### Prepare Input ####
# create named list of peakfiles
peakfiles <- list(CnR=CnR_H3K27ac, CnT=CnT_H3K27ac)
# create named list of picard outputs
picard_files <- list(CnR=CnR_H3K27ac_picard, CnT=CnT_H3K27ac_picard)
# reference peak file
reference <- list("ENCODE" = encode_H3K27ac)

### Run EpiCompare ###
output_html <- EpiCompare(peakfiles = peakfiles,
           genome_build = list(peakfiles="hg19",
                               reference="hg19"),
           picard_files = picard_files,
           reference = reference,
           output_filename = "EpiCompare_test",
           output_dir = tempdir())
# utils::browseURL(output_html)
}
