% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compileGRN.R
\name{compileGRN}
\alias{compileGRN}
\alias{compile.grn.from.kegg}
\title{Compilation of a gene regulatory network from pathway databases}
\usage{
compileGRN(
  org,
  db = "kegg",
  act.inh = TRUE,
  map2entrez = TRUE,
  keep.type = FALSE,
  kegg.native = FALSE
)
}
\arguments{
\item{org}{An organism in KEGG three letter code, e.g. \sQuote{hsa} for
\sQuote{Homo sapiens}.  Alternatively, and mainly for backward
compatibility, this can also be either a list of
\code{\linkS4class{KEGGPathway}} objects or an absolute file path of a zip
compressed archive of pathway xml files in KGML format.}

\item{db}{Pathway database.  This should be one or more DBs out of 'kegg',
'reactome', 'pathbank', and 'wikipathways'.  See \code{\link{pathwayDatabases}} for
available DBs of the respective organism.  Default is 'kegg'.
Note: when dealing with non-model organisms, GRN compilation is currently
only supported directly from KEGG (the argument \code{kegg.native} should
accordingly be set to \code{TRUE}).}

\item{act.inh}{Should gene regulatory interactions be classified as
activating (+) or inhibiting (-)?  If TRUE, this will drop interactions for
which such a classification cannot be made (e.g. binding events).
Otherwise, all interactions found in the pathway DB will be included.
Default is \code{TRUE}.}

\item{map2entrez}{Should gene identifiers be mapped to NCBI Entrez Gene IDs?
This only applies to Reactome and PathBank as they both use UNIPROT IDs.
This is typically recommended when using the GRN for network-based enrichment
analysis with the EnrichmentBrowser.  Default is \code{TRUE}.}

\item{keep.type}{Should the original interaction type descriptions be kept?
If TRUE, this will keep the long description of interaction types as found
in the original KGML and BioPax pathway files.  Default is \code{FALSE}.}

\item{kegg.native}{For KEGG: should the GRN be compiled from the native KGML
files or should graphite's pathway topology conversion be used?  See the
vignette of the graphite package for details.  This is mostly for backward
compatibility.  Default is \code{FALSE}. Note: when dealing with non-model 
organisms (not supported by graphite) this argument should be set to 
\code{TRUE}.}
}
\value{
The GRN in plain matrix format.  Two columns named \code{FROM} (the
regulator) and \code{TO} (the regulated gene) are guaranteed.  Additional
columns, named \code{TYPE} and \code{LONG.TYPE}, are included if option
\code{act.inh} or \code{keep.type} is activated.
}
\description{
To perform network-based enrichment analysis a gene regulatory network (GRN)
is required. There are well-studied processes and organisms for which
comprehensive and well-annotated regulatory networks are available, e.g. the
RegulonDB for E. coli and Yeastract for S. cerevisiae.  However, in many
cases such a network is missing.  A first simple workaround is to compile a
network from regulations in pathway databases such as KEGG.
}
\examples{

    kegg.grn <- compileGRN(org="hsa", db="kegg")

}
\seealso{
\code{\link{pathwayDatabases}}, \code{\link{pathways}},
\code{\linkS4class{KEGGPathway}}, \code{\link{parseKGML}},
\code{\link{downloadPathways}}
}
\author{
Ludwig Geistlinger
}
