% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_deseq2.R
\name{run_deseq2}
\alias{run_deseq2}
\title{Run DGE:  \pkg{DESeq2}}
\usage{
run_deseq2(exp, level2annot, test = "LRT", no_cores = 1, verbose = TRUE, ...)
}
\arguments{
\item{exp}{Expression matrix with gene names as rownames.}

\item{level2annot}{Array of cell types, with each sequentially corresponding
a column in the expression matrix.}

\item{test}{either "Wald" or "LRT", which will then use either 
Wald significance tests (defined by \code{\link[DESeq2]{nbinomWaldTest}}),
or the likelihood ratio test on the difference in deviance between a
full and reduced model formula (defined by \code{\link[DESeq2]{nbinomLRT}})}

\item{no_cores}{Number of cores to parallelise across.
Set to \code{NULL} to automatically optimise.}

\item{verbose}{Print messages.
#' @inheritParams orthogene::convert_orthologs}

\item{...}{Additional arguments to be passed to
\link[gprofiler2]{gorth} or \link[homologene]{homologene}.\cr\cr
\emph{NOTE}: To return only the most "popular"
interspecies ortholog mappings,
supply \code{mthreshold=1} here AND set \code{method="gprofiler"} above.
This procedure tends to yield a greater number of returned genes but at
 the cost of many of them not being true biological 1:1 orthologs.\cr\cr
 For more details, please see
\href{https://cran.r-project.org/web/packages/gprofiler2/vignettes/gprofiler2.html}{
 here}.}
}
\value{
\code{DESeq} results
}
\description{
Run Differential Gene Expression with \pkg{DESeq2}.
}
\keyword{internal}
