% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_marginalPlot.R
\name{ggplot2_marginPlot}
\alias{ggplot2_marginPlot}
\title{Plot percent increase in detection of DE genes across replicate levels}
\usage{
ggplot2_marginPlot(deg = NULL, stat = "median", path = ".", save_plot = TRUE)
}
\arguments{
\item{deg}{The list of DE genes generated by one of ERSSA::DE_*.R scripts.}

\item{stat}{The statistic used for plotting. Options include 'mean',
'median'. Default='median'.}

\item{path}{Path to which the plot will be saved. Default to current working
directory.}

\item{save_plot}{Boolean. Whether to save plot to drive. Default to TRUE.}
}
\value{
A list is returned containing:
 \itemize{
  \item{gg_object} {the ggplot2 object, which can then be further
  customized.}
  \item{marg_diff.dataframe} {the tidy table version of percent changes for
  plotting.}
}
}
\description{
\code{ggplot2_marginPlot} function plots the percent change in number of DE
genes identified at each step-wise increase in replicate level.
}
\details{
The percent change is calculated as (margin*100%)/(num. of DE genes at the
lower replicate level). The results are visualized as bar plots. Either mean
or median can be used for the calculation.
}
\examples{
# load edgeR deg object generated by erssa_edger using example dataset
# example dataset containing 1000 genes, 4 replicates and 5 comb. per rep.
# level
data(deg.partial, package = "ERSSA")

gg_margin = ggplot2_marginPlot(deg.partial)

}
\references{
H. Wickham. ggplot2: Elegant Graphics for Data Analysis.
Springer-Verlag New York, 2009.
}
\author{
Zixuan Shao, \email{Zixuanshao.zach@gmail.com}
}
