% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_report.R
\name{render_report}
\alias{render_report}
\title{Build report for TCGA.pipe function}
\usage{
render_report(
  title = "Report",
  mae.file,
  group.col,
  group1,
  group2,
  direction,
  dir.out,
  genome = "hg38",
  mode = "supervised",
  minSubgroupFrac = 0.2,
  minMetdiff = 0.3,
  metfdr = 0.01,
  permu = 10000,
  rawpval = 0.01,
  pe = 0.01,
  nprobes = 10,
  lower.OR = 1.1,
  out_file = file.path(getwd(), "report.html"),
  funcivar = FALSE
)
}
\arguments{
\item{title}{HTML report title}

\item{mae.file}{Absolute path to the mae used in the analysis (.rda or .rds)}

\item{group.col}{Group col}

\item{group1}{Group 1}

\item{group2}{Group 2}

\item{direction}{direction used in the analysis}

\item{dir.out}{Absolute path to folder with results. dir.out used in the analysis}

\item{genome}{Genome of reference used in the analysis}

\item{mode}{mode used in the analysis}

\item{minSubgroupFrac}{minSubgroupFrac used in the analysis}

\item{minMetdiff}{minMetdiff used in the analysis}

\item{metfdr}{metfdr used in the analysis}

\item{permu}{permu used in the analysis}

\item{rawpval}{rawpval used in the analysis}

\item{pe}{pe used in the analysis}

\item{nprobes}{nprobes used in the analysis}

\item{lower.OR}{lower.OR used in the analysis}

\item{out_file}{Output file name (i.e report.html)}

\item{funcivar}{Include funcivar analysis?}
}
\description{
Build HTML report
}
\examples{
\dontrun{
render_report(
 group.col = "TN",
 group1 = "Tumor",
 group2 = "Normal",
 dir.out = "~/paper_elmer/Result/BRCA/TN_Tumor_vs_Normal/hypo/",
 direction = "hypo",
 mae.file = "~/paper_elmer/Result/BRCA/BRCA_mae_hg38.rda"
)
}
}
