% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGA_pipe.R
\name{addMutCol}
\alias{addMutCol}
\title{Adds mutation information to MAE}
\usage{
addMutCol(
  data,
  disease,
  genes,
  mutant_variant_classification = c("Frame_Shift_Del", "Frame_Shift_Ins",
    "Missense_Mutation", "Nonsense_Mutation", "Splice_Site", "In_Frame_Del",
    "In_Frame_Ins", "Translation_Start_Site", "Nonstop_Mutation")
)
}
\arguments{
\item{data}{MAE object}

\item{disease}{TCGA disease (LUSC, GBM, etc)}

\item{genes}{list of genes to add information}

\item{mutant_variant_classification}{List of mutant_variant_classification that will be 
consider a sample mutant or not.}
}
\description{
Adds mutation information to MAE
}
\examples{
\dontrun{
 data <- ELMER:::getdata("elmer.data.example") # Get data from ELMER.data
 data <- ELMER:::addMutCol(data, "LUSC","TP53")
}
}
