% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assortativity.R
\name{assortativity}
\alias{assortativity}
\title{Calculating network assortativity}
\usage{
assortativity(network)
}
\arguments{
\item{network}{matrix indicating network structure (symmetric)}
}
\value{
Numeric value
}
\description{
The function calculates the assortativity of a network, 
that measures the preference of interactions between similar nodes. 
As in most literature, 'similarity' is here defined in terms of node degrees.
}
\examples{
network <- matrix( sample(c(0,1),36, replace=TRUE), nrow=6,byrow=TRUE)
assort_value <- assortativity(network)

}
\keyword{assortativity}
\keyword{network}
\keyword{properties}
\keyword{topology}
