% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeGiToSAMfile.R
\name{writeGiToSAMfile}
\alias{writeGiToSAMfile}
\title{Write reads to sam file}
\usage{
writeGiToSAMfile(
  gi_coords,
  file_out,
  distance_chim_junction = 10000,
  read_name_column = "readname",
  id_column = "dg_id",
  genome = "",
  sample_name = "noname_sample"
)
}
\arguments{
\item{gi_coords}{input Ginteraction object}

\item{file_out}{path to write output file}

\item{distance_chim_junction}{maximum distance between input
duplex groups/reads, which will be represented as the single-line in .sam file.
Junction will be output as N- gap. For the interactions with longer distances,
chimeric junction will be represented as MR:Z:i tag}

\item{read_name_column}{character field, pointing out to read names.
Read names are generated automatically if not provided.}

\item{id_column}{character name of the field containing integer duplex group ids.
NA are replaced with zeros}

\item{genome}{character. Genome version. Required for the retrieval of sequence lengths
for sam file header-  SQ and SN tags.
For convenience, hg38 and hg19 chromosome lengths will be assigned
automatically.
If the value is not in c('hg38','hg19'), seqlengths will be looked for be in
attribute in seqlengths() of regions(gi_coords)}

\item{sample_name}{name to use in RG SAM tag in header}
}
\value{
no object is returned
}
\description{
Writes interactions to the sam file for visualization in extrnal browsers.
Takes input as GInteractions object containing reads or duplex groups.
}
\examples{
# Load test data
data("RNADuplexesSampleData")
# if the input is read-based, it should have integer duplex group ids
# here, we have 2090 reads
length(RNADuplexSampleGI)
# among them 300 reads does not belong to any DG
# missing ids will be converted to 0
table(is.na(RNADuplexSampleGI$dg_id))
tmpf <- tempfile(".sam")
writeGiToSAMfile(
    gi_coords = RNADuplexSampleGI,
    id_column = "dg_id",
    file_out = tmpf,
    distance_chim_junction = 1e5,
    genome = "hg38"
)
}
