% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{discoQC}
\alias{discoQC}
\alias{discoPCAoutliers}
\alias{discoInterCorOutliers}
\alias{discoRepAnalysis}
\title{Quality Control for DiscoRhythm}
\usage{
discoPCAoutliers(se, threshold = 3, scale = TRUE, pcToCut = seq_len(4))

discoInterCorOutliers(
  se,
  cor_method = c("pearson", "kendall", "spearman"),
  threshold = 3,
  thresh_type = c("sd", "value")
)

discoRepAnalysis(
  se,
  aov_method = c("Equal Variance", "Welch", "None"),
  aov_pcut = 0.05,
  aov_Fcut = 0,
  avg_method = c("Median", "Mean", "Random", "None")
)
}
\arguments{
\item{se}{SummarizedExperiment, the main data object used by DiscoRhythm 
expected to contain se$ID, se$ReplicateID, se$Time sample metadata and
non-null rownames. See the vignette for more details.}

\item{threshold}{numeric, a threshold determining which samples are
outliers (for discoInterCorOutliers, in units of thresh_type, for
discoPCAoutliers in units of standard deviations).}

\item{scale}{logical, whether or not to scale the data prior to PCA, see
\link[stats]{prcomp} for more details.}

\item{pcToCut}{numeric, which PCs to use for outlier detection. It is
recomended to select the first X PCs based on which PCs explain a
significant amount of variance in the data.}

\item{cor_method}{character, method of pairwise correlation
(see \link[stats]{cor}'s "method" argument for all options).}

\item{thresh_type}{character indicating threshold type (either standard
deviations below the mean, or an absolution correlation value). One of:
"sd" or "value".}

\item{aov_method}{character, method to use for ANOVA. One of:
"Equal Variance", "Welch", or "None".}

\item{aov_pcut}{numeric, p-value cutoff used to select rows with
statistically significant signal-to-noise.}

\item{aov_Fcut}{numeric, F-statistic cutoff used to select rows
with high signal-to-noise based on magnitude.}

\item{avg_method}{character, method for averaging technical replicates. One
of: "Median","Mean","Random", or "None".}
}
\value{
list containing PCA results and the detected outliers

A list of 3 objects:
1) outliers - named logical indicating if the sample is an outlier
2) meanCor - mean of all pairwise correlations for a given sample
3) corMat - Matrix of all pairwise correlation values
}
\description{
Functions for executing outlier detection and row filtering procedures
prior to rhythmicity analysis.
}
\examples{
se <- discoGetSimu(TRUE)
PCAres <- discoPCAoutliers(se)

CorRes <- discoInterCorOutliers(se)

ANOVAres <- discoRepAnalysis(se)

}
