% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depeche.R
\name{depeche}
\alias{depeche}
\title{Perform optimization and penalized K-means clustering}
\usage{
depeche(
  inDataFrame,
  samplingSubset = seq_len(nrow(inDataFrame)),
  penalties = 2^seq(0, 5, by = 0.5),
  sampleSize = "default",
  selectionSampleSize = "default",
  k = 30,
  minARIImprovement = 0.01,
  optimARI = 0.95,
  maxIter = 100,
  log2Off = FALSE,
  center = "default",
  scale = TRUE,
  nCores = "default",
  plotDir = ".",
  createOutput = TRUE
)
}
\arguments{
\item{inDataFrame}{A dataframe or matrix with the data that will be used to
create the clustering. Cytometry data should be transformed using
biexponential, arcsinh transformation or similar, and day-to-day
normalizations should to be performed for all data if not all data has been
acquired on the same run. Scaling, etc, is on the other hand performed
within the function.}

\item{samplingSubset}{If the dataset is made up of an unequal number of cells
from multiple individuals, it might be wise to pre-define a subset of the
rows, which includes equal or near-equal numbers of cells from each
individual, to avoid a few outliers to dominate the analysis. This can be
done here. Should be a vector of row numbers in the inDataFrame.}

\item{penalties}{This argument decides whether a single penalty will be used
for clustering, or if multiple penalties will be evaluated to identify the
optimal one. A single value, a vector of values, or possibly a list of two
vectors, if dual clustering is performed can be given here. The suggested
default values are empirically defined and might not be optimal for a
specific dataset, but the algorithm will warn if the most optimal values are
on the borders of the range. Note that when the penalty is 0, there is no
penalization, which means that the algorithm runs standard K-means
clustering.}

\item{sampleSize}{This controls what fraction of the dataset that will be
used to run the penalty optimization. 'default' results in the full file in
files up to 10000 events. In cases where the sampleSize argument is larger
than 10000, default leads to the generation of a random subset to the same
size also for the selectionSampleSize. A user specified number is also
accepted.}

\item{selectionSampleSize}{The size of the dataset used to find the optimal
solution out of the many generated by the penalty optimization at each sample
size. 'default' results in the full file in files up to 10000 events. In
cases where the sampleSize argument is larger than 10000, default leads to
the generation of a random subset to the same size also for the
selectionSampleSize. A user specified number is also accepted.}

\item{k}{Number of initial cluster centers. The higher the number, the
greater the precision of the clustering, but the computing time also
increases linearly with the number of starting points. Default is 30. If
penalties=0, k-means clustering with k clusters will be performed.}

\item{minARIImprovement}{This is the stop criterion for the penalty
optimization algorithm: the more iterations that are run, the smaller will
the improvement of the corrected Rand index be, and this sets the threshold
when the inner iterations stop. Defaults to 0.01.}

\item{optimARI}{Above this level of ARI, all solutions are considered equally
valid, and the median solution is selected among them.}

\item{maxIter}{The maximal number of iterations that are performed in the
penalty optimization.}

\item{log2Off}{If the automatic detection for high kurtosis, and followingly,
the log2 transformation, should be turned off.}

\item{center}{If centering should be performed. Alternatives are 'default',
'mean', 'peak', FALSE and a vector of numbers with the same length as the
number of columns in the inDataFrame. 'peak' results in centering around the
highest peak in the data, which is useful in most cytometry situations.
'mean' results in  mean centering. 'default' gives different results
depending on the data: datasets with 100+ variables are mean centered,
and otherwise, peak centering is used. If a numeric vector is provided, it
is used to center the values to the numbers. This is preferable to
pre-centering the data and using the FALSE command, as it will lead to better
internal visualization procedures, etc. FALSE results in no centering, mainly
for testing purposes.}

\item{scale}{If scaling should be performed. If TRUE, the dataset will be
divided by the combined standard deviation of the whole dataset. If a number
is provided, the dataset is divided by this number. This scaling
procedure makes the default penalties fit most datasets with some precision.}

\item{nCores}{If multiCore is TRUE, then this sets the number of parallel
processes. The default is currently 87.5 percent with a cap on 10 cores, as
no speed increase is generally seen above 10 cores for normal computers.}

\item{plotDir}{Where should the diagnostic plots be printed?}

\item{createOutput}{For testing purposes. Defaults to TRUE. If FALSE, no
plots are generated.}
}
\value{
A nested list:
\describe{
   \item{clusterVector}{A vector with the same length as number of rows in
   the inDataFrame, where the cluster identity of each observation is
   noted.}
   \item{clusterCenters}{A matrix containing information
   about where the centers are in all the variables that contributed to
   creating the cluster with the given penalty term. An exact zero here
   indicates that the variable in question was sparsed out for that cluster.
   If a variable did not contribute to the separation of any cluster, it will
   not be present here.}
   \item{essenceElementList}{A per-cluster list of the items that were
   used to separate that cluster from the rest, i.e. the items that survived
   the penalty.}
   \item{penaltyOptList}{A list of two dataframes:
   \describe{
             \item{penaltyOpt.df}{A one row dataframe with the settings for
             the optimal penalty.}
             \item{meanOptimDf}{A dataframe with the information about the
             results with all tested penalty values.}
           }
    }
    \item{logCenterScale}{The values used to center and scale the
    data and information on if the data was log transformed. This
    information is used internally in dAllocate.}
}
}
\description{
This is the central function of the package. As input, only a dataset is
required. It starts by performing optimizations and then performs clustering
based on the values identified in the optimization step.
}
\examples{
# Load some data
data(testData)

# Here a run with the standard settings
\dontrun{
testDataDepecheResult <- depeche(testData[, 2:15])

# Look at the result
str(testDataDepecheResult)
}

}
