% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denoist.R
\name{denoist}
\alias{denoist}
\title{DenoIST}
\usage{
denoist(
  mat,
  tx,
  coords = NULL,
  tx_x = "x",
  tx_y = "y",
  feature_label = "gene",
  distance = 50,
  nbins = 200,
  posterior_cutoff = 0.6,
  cl = 1,
  out_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{mat}{A matrix of counts (genes x cells), or a SpatialExperiment object.}

\item{tx}{A data frame of transcript with x, y and qv columns.}

\item{coords}{A data frame of coordinates (n_cells x 2). Only used if not using a SpatialExperiment object as input.}

\item{tx_x}{Column name for the x coordinates in the transcripts dataframe. Default is 'x'.}

\item{tx_y}{Column name for the y coordinates in the transcripts dataframe. Default is 'y'.}

\item{feature_label}{Column name for the gene of each transcript in the transcripts dataframe. Default is 'gene'.}

\item{distance}{The maximum distance to consider for local background estimation.}

\item{nbins}{The number of bins to use for hexagonal binning.}

\item{posterior_cutoff}{The cutoff for posterior probability to determine contamination.}

\item{cl}{The number of cores to use for parallel processing.}

\item{out_dir}{The output directory to save the results.}

\item{verbose}{Logical, if TRUE, print progress messages.}
}
\value{
A list containing the following elements:
\item{memberships}{A matrix of memberships for each gene in each cell.}
\item{adjusted_counts}{A matrix of adjusted counts for each gene in each cell.}
\item{params}{A list of parameters for each gene.}
}
\description{
DenoIST (Denoising Image-based Spatial Transcriptomics) is a method for
identifying and removing contamination artefacts in
image-based single-cell transcriptomics (IST) data.
It uses a transposed Poisson mixture model to identify contamination.
}
\details{
The function calculates local background using hexagonal binning and applies
a Poisson mixture model to identify contamination.
It returns a matrix of memberships and adjusted counts for each gene in each cell.
}
\examples{
# Load example data
set.seed(42)
mat <- matrix(rpois(1000, lambda = 10), nrow = 10, ncol = 100)
rownames(mat) <- paste0("gene", 1:10)
coords <- data.frame(x = rnorm(100), y = rnorm(100))
tx <- data.frame(x = c(rnorm(500), rnorm(500, 3)),
                 y = c(rnorm(500), rnorm(500, 3)),
                 qv = rep(30, 1000), gene = paste0('gene', 1:10))
# Run DenoIST
result <- denoist(mat, tx, coords, distance = 1, nbins = 50, cl = 1,
                  out_dir = NULL, verbose = TRUE)
# Check results
print(result$memberships[1:5, 1:5])
print(result$adjusted_counts[1:5, 1:5])
print(result$params[[1]])
}
