% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomLogisArray-class.R
\docType{class}
\name{RandomLogisArray-class}
\alias{RandomLogisArray-class}
\alias{RandomLogisArraySeed-class}
\alias{RandomLogisMatrix-class}
\alias{sampleDistrParam,RandomLogisArraySeed-method}
\alias{sampleDistrFun,RandomLogisArraySeed-method}
\alias{matrixClass,RandomLogisArray-method}
\alias{RandomLogisArraySeed}
\alias{DelayedArray,RandomLogisArraySeed-method}
\alias{RandomLogisArray}
\title{DelayedArray of random log-normal values}
\usage{
RandomLogisArraySeed(dim, location = 0, scale = 1, chunkdim = NULL)

\S4method{DelayedArray}{RandomLogisArraySeed}(seed)

RandomLogisArray(dim, location = 0, scale = 1, chunkdim = NULL)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{location, scale}{Numeric vector used as the argument of the same name in \code{\link{qlogis}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{seed}{A RandomLogisArraySeed object.}
}
\value{
All constructors return an instance of a RandomLogisArray object,
containing random draws from a log-normal distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of log-normally distributed values.
}
\examples{
X <- RandomLogisArraySeed(c(1e5, 1e5))
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomLogisArraySeed(c(1e5, 1e5), location=runif(1e5), scale=runif(1e5))
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
location <- rsparsematrix(1e5, 1e5, density=0.00001)
X3 <- RandomLogisArraySeed(c(1e5, 1e5), location=location)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
