% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomLnormArray-class.R
\docType{class}
\name{RandomLnormArray-class}
\alias{RandomLnormArray-class}
\alias{RandomLnormArraySeed-class}
\alias{RandomLnormMatrix-class}
\alias{sampleDistrParam,RandomLnormArraySeed-method}
\alias{sampleDistrFun,RandomLnormArraySeed-method}
\alias{matrixClass,RandomLnormArray-method}
\alias{RandomLnormArraySeed}
\alias{DelayedArray,RandomLnormArraySeed-method}
\alias{RandomLnormArray}
\title{DelayedArray of random log-normal values}
\usage{
RandomLnormArraySeed(dim, meanlog = 0, sdlog = 1, chunkdim = NULL)

\S4method{DelayedArray}{RandomLnormArraySeed}(seed)

RandomLnormArray(dim, meanlog = 0, sdlog = 1, chunkdim = NULL)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{meanlog, sdlog}{Numeric vector used as the argument of the same name in \code{\link{qlnorm}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{seed}{A RandomLnormArraySeed object.}
}
\value{
All constructors return an instance of a RandomLnormArray object,
containing random draws from a log-normal distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of log-normally distributed values.
}
\examples{
X <- RandomLnormArraySeed(c(1e5, 1e5))
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomLnormArraySeed(c(1e5, 1e5), meanlog=runif(1e5), sdlog=runif(1e5))
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
meanlog <- rsparsematrix(1e5, 1e5, density=0.00001)
X3 <- RandomLnormArraySeed(c(1e5, 1e5), meanlog=meanlog)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
