% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RandomCauchyArray-class.R
\docType{class}
\name{RandomCauchyArray-class}
\alias{RandomCauchyArray-class}
\alias{RandomCauchyArraySeed-class}
\alias{RandomCauchyMatrix-class}
\alias{sampleDistrParam,RandomCauchyArraySeed-method}
\alias{sampleDistrFun,RandomCauchyArraySeed-method}
\alias{matrixClass,RandomCauchyArray-method}
\alias{RandomCauchyArraySeed}
\alias{DelayedArray,RandomCauchyArraySeed-method}
\alias{RandomCauchyArray}
\title{DelayedArray of random Cauchy-distributed values}
\usage{
RandomCauchyArraySeed(dim, location = 0, scale = 1, chunkdim = NULL)

\S4method{DelayedArray}{RandomCauchyArraySeed}(seed)

RandomCauchyArray(dim, location = 0, scale = 1, chunkdim = NULL)
}
\arguments{
\item{dim}{Integer vector of positive length, specifying the dimensions of the array.}

\item{location, scale}{Numeric vector used as the argument of the same name in \code{\link{qcauchy}}.
Alternatively, a numeric array-like object with the same dimensions as \code{dim}.}

\item{chunkdim}{Integer vector of length equal to \code{dim}, containing the dimensions of each chunk.}

\item{seed}{A RandomCauchyArraySeed object.}
}
\value{
All constructors return an instance of a RandomCauchyArray object,
containing random draws from a Cauchy distribution with the specified parameters.
}
\description{
A \linkS4class{DelayedArray} subclass that performs on-the-fly sampling of Cauchy-distributed values.
}
\examples{
X <- RandomCauchyArraySeed(c(1e5, 1e5))
Y <- DelayedArray(X)
Y

# Fiddling with the distribution parameters:
X2 <- RandomCauchyArraySeed(c(1e5, 1e5), location=runif(1e5))
Y2 <- DelayedArray(X2)
Y2

# Using another array as input:
library(Matrix)
loc <- rsparsematrix(1e5, 1e5, density=0.00001)
X3 <- RandomCauchyArraySeed(c(1e5, 1e5), location=loc)
Y3 <- DelayedArray(X3)
Y3

}
\seealso{
The \linkS4class{RandomArraySeed} class, for details on chunking and the distributional parameters.
}
\author{
Aaron Lun
}
