% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/degCreConversions.R
\name{calcRawAssocProbOR}
\alias{calcRawAssocProbOR}
\title{Calculate Raw Association Probability Odds Ratio (OR)}
\usage{
calcRawAssocProbOR(degCreResList)
}
\arguments{
\item{degCreResList}{List of DegCre results.}
}
\value{
A numeric vector of raw association probability odds ratios (OR)
for each association.
}
\description{
Given a DegCre results list, this function calculates the raw association
probability odds ratio (OR) for each association.
}
\details{
This function calculates the raw association probability odds ratio (OR)
for each association in a DegCre analysis output.
The OR is calculated relative to the distance bin null association
probability, which would happen if all CRE p-values were identical.
Thus it is a measure of the increase in association probability due to
CRE p-value information content over what would occur by random chance.
}
\examples{
#Load required packages.
library(GenomicRanges)

#Load test data.
data(DexNR3C1)

subDegGR <-
 DexNR3C1$DegGR[which(Seqinfo::seqnames(DexNR3C1$DegGR)=="chr1")]
subCreGR <-
 DexNR3C1$CreGR[which(Seqinfo::seqnames(DexNR3C1$CreGR)=="chr1")]

#Generate DegCre results.
degCreResListDexNR3C1 <- runDegCre(DegGR=subDegGR,
                                   DegP=subDegGR$pVal,
                                   DegLfc=subDegGR$logFC,
                                   CreGR=subCreGR,
                                   CreP=subCreGR$pVal,
                                   CreLfc=subCreGR$logFC)

#Calculate raw odds ratio.
ORvec <- calcRawAssocProbOR(degCreResListDexNR3C1)

}
\author{
Brian S. Roberts
}
