% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_cell_colors.R
\name{create_cell_colors}
\alias{create_cell_colors}
\title{Create a cell color palette for plots}
\usage{
create_cell_colors(
  cell_types = c("Astro", "Micro", "Endo", "Oligo", "OPC", "Excit", "Inhib", "Other"),
  palette_name = c("classic", "gg", "tableau"),
  palette = NULL,
  split = NA,
  preview = FALSE
)
}
\arguments{
\item{cell_types}{A \code{character()} vector listing unique cell types.}

\item{palette_name}{A \code{character(1)} indicating choice of included palettes:
\itemize{
\item \code{"classic"}: classic set of 8 cell type colors from LIBD, checked for
visability and color blind accessibility. Default palette.
\item \code{"gg"} : mimic colors automatically picked by ggplot.
\item \code{"tableau"} : 20 distinct colors from tableau color palette, good for
large number of cell type.
}}

\item{palette}{A \code{character()} vector listing user provided color palette. If
provided, overrides palette selection with palette_name.}

\item{split}{delineating \code{character(1)} after which suffixes will be ignored.
This is useful for cases when say \code{A.1} and \code{A.2} are both to be considered
fine subtypes of broad cell type \code{A} (here \code{split = "\\\\."}). When used the
function returns a nested list of borad and fine cell types.}

\item{preview}{A \code{logical(1)} indicating whether to make a plot to preview
the colors.}
}
\value{
A named \code{character()} vector of R and hex color values compatible
with \code{ggplot2:scale_color_manual()}.
}
\description{
This function returns a \code{character()} vector with valid R colors for a given
input \code{character()} of unique cell types. These were colors that have been
useful in our experience.
}
\examples{
## create cell colors with included palettes
create_cell_colors(palette_name = "classic")
create_cell_colors(palette_name = "classic", preview = TRUE)
create_cell_colors(palette_name = "tableau", preview = TRUE)

## use custom colors
my_colors <- c("darkorchid4", "deeppink4", "aquamarine3", "darkolivegreen1")
create_cell_colors(
    cell_type = c("A", "B", "C", "D"),
    palette = my_colors,
    preview = TRUE
)

## use Rcolor brewer
create_cell_colors(
    cell_type = c("A", "B", "C"),
    palette = RColorBrewer::brewer.pal(n = 3, name = "Set1"),
    previe = TRUE
)

## Options for subtype handling
## Provide unique colors for cell subtypes (DEFAULT) - returns one level list
create_cell_colors(
    cell_types = c("A.1", "A.2", "B.1", "C", "D"),
    palette_name = "classic",
    preview = FALSE
)

## Provide gradient colors for A.1 and A.2 by using the "split" argument
## returns a nested list with broad & fine cell type colors, fine cell types
## are gradient with the top level matching the broad cell type
create_cell_colors(
    cell_types = c("A.1", "A.2", "B.1", "C", "D"),
    split = "\\\\.",
    palette_name = "classic",
    preview = TRUE
)

## try with custom colors
create_cell_colors(
    cell_types = c("A.1", "A.2", "B.1", "C", "D"),
    split = "\\\\.",
    palette = my_colors,
    preview = TRUE
)

}
