% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_wrap.R
\name{plotWrap}
\alias{plotWrap}
\title{Wrapper function for plotting}
\usage{
plotWrap(
  id = NULL,
  seqnames = NULL,
  start_region = NULL,
  end_region = NULL,
  counts.df = NULL,
  dm_results.df = NULL,
  peaks.df = NULL,
  genes.df = NULL,
  txdb = NULL,
  gatc_sites.df = NULL,
  extend_by = 250,
  ...
)
}
\arguments{
\item{id}{A character vector of peak OR gene identifier(s) if wish to plot in peak/gene centric manner. Default is NULL.}

\item{seqnames}{A chromosome. Default is NULL.}

\item{start_region}{A number providing the start of region to plot. Default is NULL.}

\item{end_region}{A number providing the end of region to plot. Default is NULL.}

\item{counts.df}{A data.frame of counts as from [process_bams()]. Default is NULL.}

\item{dm_results.df}{A data.frame of dm results as from [edgeR_results()]. Default is NULL.}

\item{peaks.df}{A data.frame of peaks as from [aggregate_peaks()]. Default is NULL.}

\item{genes.df}{A data.frame of genes as from [get_biomart_genes()]. Default is NULL.}

\item{txdb}{A TxDb object as from a TxDb package. Default is NULL.}

\item{gatc_sites.df}{A data.frame of gatc sites as from [gatc_track()$sites]. Default is NULL.}

\item{extend_by}{A number to extend the limits of the provided region by. Default is 250 bp.}

\item{...}{arguments passed to geom_genes.me. Allows for adjusting of the plot appearance via gene_limits and plot.height if necessary.
* Default for gene_limits is NULL. If the gene is disproportionately large for the plot space, we recommend reducing the size with gene_limits = c(0,2)}
}
\value{
A `ggplot2` object - or list of plots if provided multiple peaks/genes
}
\description{
`plot_wrap` plots all the available plots at once
}
\examples{
library("TxDb.Dmelanogaster.UCSC.dm6.ensGene")
library("org.Dm.eg.db")
set.seed(123)
example_regions <- random_regions()
gatc_sites <- dplyr::mutate(example_regions,
    start = start - 3, end = start + 4, width = end - start + 1
)
counts.df <- random_counts()
dm_results <- random_edgeR_results()
peaks <- identifyPeaks(dm_results)

txdb <- TxDb.Dmelanogaster.UCSC.dm6.ensGene
genes <- collateGenes(txdb, example_regions, org.Db = org.Dm.eg.db)

## plot using a peak_id
plotWrap(
    id = peaks[1, ]$peak_id,
    counts.df = counts.df,
    dm_results.df = dm_results,
    peaks.df = peaks,
    gatc_sites.df = gatc_sites,
    genes.df = genes, txdb = txdb
)

## plot using a gene id
plotWrap(
    id = genes[1, ]$ensembl_gene_id,
    counts.df = counts.df,
    dm_results.df = dm_results,
    peaks.df = peaks,
    gatc_sites.df = gatc_sites,
    genes.df = genes, txdb = txdb
)

## plot providing a region
plotWrap(
    seqnames = "chr2L", start_region = 1, end_region = 5000,
    counts.df = counts.df,
    dm_results.df = dm_results,
    peaks.df = peaks,
    gatc_sites.df = gatc_sites,
    genes.df = genes, txdb = txdb
)

## plot multiple peaks or genes by providing a vector of id's
plotWrap(
    id = peaks[1:2, ]$peak_id,
    counts.df = counts.df,
    dm_results.df = dm_results,
    peaks.df = peaks,
    gatc_sites.df = gatc_sites,
    genes.df = genes, txdb = txdb
)

}
\seealso{
[geom_peak()] [geom_dm()] [geom_genes()] [geom_gatc()] [plotCounts()]
}
