% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_genes.R
\name{geom_genes_tx}
\alias{geom_genes_tx}
\title{Plotting genes}
\usage{
geom_genes_tx(
  genes.df,
  txdb,
  gene_limits = NULL,
  plot.space = 0.1,
  plot.height = 0.3
)
}
\arguments{
\item{genes.df}{A data.frame of genes as outputted from `get_biomart_genes`.}

\item{txdb}{A TxDb object as from a TxDb package.}

\item{gene_limits}{Set the height of the transcripts generated by `ggbio::autoplot()`. Default is NULL.
* If the gene is disproportionately large for the plot space, we recommend reducing the size with gene_limits = c(0,2).
* If there are a large amount of transcripts present, we recommend increasing the overall limit, example: gene_limits = c(0,11).}

\item{plot.space}{Specify gap to next plot. Recommend leaving to the default: 0.1.}

\item{plot.height}{Specify overall height of plot. Recommend leaving to the default: 0.3.}
}
\value{
A `ggplot_add` object.
}
\description{
`geom_genes_tx` is a ggplot2 layer that visualises the positions of genes across a given region.
* cannot be plotted by itself, must be added to an existing ggplot object - see examples.
}
\examples{
library(TxDb.Dmelanogaster.UCSC.dm6.ensGene)
library(org.Dm.eg.db)
set.seed(123)
example_regions <- random_regions()
counts.df <- random_counts()

txdb <- TxDb.Dmelanogaster.UCSC.dm6.ensGene
genes <- collateGenes(txdb, example_regions, org.Dm.eg.db)

plotCounts(counts.df,
    seqnames = "chr2L",
    start_region = 1,
    end_region = 40000,
    log2_scale = FALSE
) +
    geom_genes_tx(genes, txdb)

}
\references{
ggcoverage - Visualise and annotate omics coverage with ggplot2. https://github.com/showteeth/ggcoverage/tree/main
Yin T, Cook D, Lawrence M (2012). “ggbio: an R package for extending the grammar of graphics for genomic data.” Genome Biology, 13(8), R77.
}
\seealso{
[geom_peak()] [geom_dm()] [geom_counts()] [geom_gatc()] [plotWrap()] [ggplot2::ggplot_add()]
}
