% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_bams.R
\name{countBamInGATC}
\alias{countBamInGATC}
\title{Obtain region counts for BAM files}
\usage{
countBamInGATC(path_to_bams, regions, nthreads = 2, ...)
}
\arguments{
\item{path_to_bams}{A string identifying the directory containing the BAM files.}

\item{regions}{A GRanges object of GATC regions. The GATC regions can be made with `gatc_track()`.}

\item{nthreads}{The number of computer cores to be used to parallelise the function and decrease it's run time. If not specified, will use default (2 cores).
* If computer is being used for multiple tasks at once, we recommend reducing the number of cores - or leave it at the default setting.
* The number of available cores can be checked using [parallel::detectCores()]}

\item{...}{Other arguments passed onto `Rsubread::featureCounts()`}
}
\value{
A `data.frame` containing the GATC region information in the form in the columns: seqnames (chromosome), start, end, width, and strand. The count information for the BAM files is in the subsequent columns, named by the name of the BAM file.
* The ".bam" extension is retained in the sample name as an identifier for the sample columns
* If necessary, at this stage please rearrange the BAM file columns so they are ordered in the following way: Dam_1, Fusion_1, Dam_2, Fusion_2 etc
* The DamID data captures the ~75bp region extending from each GATC site, so although regions are of differing widths, there is a null to minimal length bias present on the data, and does not require length correction.
}
\description{
`countBamInGATC()` obtains the raw counts for the regions between GATC sites, from indexed BAM files specified in the path.
}
\examples{
path_to_bams <- system.file("extdata", package = "Damsel")
example_regions <- random_regions()
counts.df <- countBamInGATC(path_to_bams,
    regions = example_regions,
    nthreads = 2
)
head(counts.df)
# rearrange columns of bam files so that: Dam_1, Fusion_1, Dam_2, Fusion_2
}
\references{
Liao Y, Smyth GK, Shi W (2019). “The R package Rsubread is easier, faster, cheaper and better for alignment and quantification of RNA sequencing reads.” Nucleic Acids Research, 47, e47. doi:10.1093/nar/gkz114.
Morgan M, Pagès H, Obenchain V, Hayden N (2024). Rsamtools: Binary alignment (BAM), FASTA, variant call (BCF), and tabix file import. R package version 2.19.3, https://bioconductor.org/packages/Rsamtools.
}
