% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_annotation.R
\name{annotatePeaksGenes}
\alias{annotatePeaksGenes}
\title{Annotation of peaks and genes}
\usage{
annotatePeaksGenes(peaks, genes, regions, max_distance = 5000)
}
\arguments{
\item{peaks}{A data.frame of peaks as outputted from [aggregate_peaks()].}

\item{genes}{A data.frame of genes as outputted from [get_biomart_genes()].}

\item{regions}{A `GRanges` object of GATC regions.}

\item{max_distance}{A number providing the limit for the minimum distance from peak to gene.
* Default is 5000. If set to `NULL`, will output all available combinations.}
}
\value{
A `list` of 3 `data.frames`:
* closest - every peak with it's closest gene
* top_5 - every peak with list of 5 closest genes
* all - all genes matching to each peak and all information
}
\description{
`annotatePeaksGenes` identifies the closest gene(s) for the peaks outputted from `aggregate_peaks()`.

This distance is relative, as the function will identify the closest genes, even if they are up to a million bp away. The max_distance parameter limits this, with a default setting of 5000 bp. All of the possible pairings are visible with `max_distance=NULL`.
The minimum distance between the peak and gene is calculated, (0 if the peak is within the gene or vice versa) and the relative position of the peak to the gene is also provided (Upstream, Downstream, Overlapping upstream, Contained within etc).
}
\examples{
library(TxDb.Dmelanogaster.UCSC.dm6.ensGene)
library(org.Dm.eg.db)
set.seed(123)
example_regions <- random_regions()
dm_results <- random_edgeR_results()
peaks <- identifyPeaks(dm_results)
txdb <- TxDb.Dmelanogaster.UCSC.dm6.ensGene
genes <- collateGenes(genes = txdb, regions = example_regions, org.Db = org.Dm.eg.db)

annotatePeaksGenes(peaks, genes, example_regions, max_distance = 5000)
# view all combinations
annotatePeaksGenes(peaks, genes, example_regions, max_distance = NULL)
}
