% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DO.Subset.R
\name{DO.Subset}
\alias{DO.Subset}
\title{DO.Subset}
\usage{
DO.Subset(
  sce_object,
  assay = "RNA",
  ident,
  ident_name = NULL,
  ident_thresh = NULL
)
}
\arguments{
\item{sce_object}{The seurat or SCE object}

\item{assay}{assay to subset by}

\item{ident}{meta data column to subset for}

\item{ident_name}{name of group of barcodes in ident of subset for}

\item{ident_thresh}{numeric thresholds as character,
e.g ">5" or c(">5", "<200"), to subset barcodes in ident}
}
\value{
a subsetted Seurat or SCE object
}
\description{
Creates a subset of a Seurat or SCE object based on either
categorical or numeric thresholds in metadata. Allows for subsetting by
specifying the ident column, group name, or threshold criteria. Ideal for
extracting specific cell populations or clusters based on custom conditions.
Returns a new Seurat or SCE object containing only the subsetted cells and
does not come with the Seuratv5 subset issue. Please be aware that right now,
after using this function the subset might be treated with Seuv5=False in
other functions.
}
\examples{
sce_data <-
    readRDS(system.file("extdata", "sce_data.rds", package = "DOtools"))

sce_data_sub <- DO.Subset(
    sce_object = sce_data,
    ident = "condition",
    ident_name = "healthy"
)

}
\author{
Mariano Ruz Jurado
}
