% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{strandBool}
\alias{strandBool}
\title{Get logical list of strands}
\usage{
strandBool(grl)
}
\arguments{
\item{grl}{a \code{\link[GenomicRanges]{GRangesList}} or GRanges object}
}
\value{
a logical vector
}
\description{
Helper function to get a logical list of True/False,
if GRangesList group have + strand = T, if - strand = F
Also checks for * strands, so a good check for bugs
}
\examples{
\dontrun{
gr <- GRanges(Rle(c("chr2", "chr2", "chr1", "chr3"), c(1, 3, 2, 4)),
              IRanges(1:10, width = 10:1),
              Rle(strand(c("-", "+", "*", "+", "-")), c(1, 2, 2, 3, 2)))
strandBool(gr)
}

}
\references{
Tjeldnes, H., Labun, K., Torres Cleuren, Y. et al.
ORFik: a comprehensive R toolkit for the analysis of translation.
BMC Bioinformatics 22, 336 (2021). DOI: 10.1186/s12859-021-04254-w
}
\author{
Haakon Tjeldnes et al.
}
\keyword{internal}
