% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{findORFsFasta}
\alias{findORFsFasta}
\title{Find ORFs in FASTA sequences using ORFik's C++ engine}
\usage{
findORFsFasta(
  sequences,
  start_codons = "ATG",
  stop_codons = "TAA",
  min_len = 0,
  longest_orf = TRUE,
  is_circular = FALSE,
  plus_strand_only = TRUE
)
}
\arguments{
\item{sequences}{Character path to a FASTA file, or a \code{DNAStringSet}
or \code{BSgenome} object.}

\item{start_codons}{Character string of start codons
(e.g., "ATG|GTG")}

\item{stop_codons}{Character string of stop codons
(e.g., "TAA|TAG")}

\item{min_len}{Integer. Minimum ORF length in bases. Default is \code{0}.}

\item{longest_orf}{Logical. If TRUE, return only the longest ORF per
sequence.}

\item{is_circular}{Logical. Whether the genome is circular
(e.g., bacterial genomes).}

\item{plus_strand_only}{Logical. If TRUE, scan only the forward strand;
if FALSE, scan both strands.}
}
\value{
A \code{GRanges} object containing the ORFs found.
}
\description{
This function identifies ORFs in DNA sequences from FASTA files,
\code{DNAStringSet}, or \code{BSgenome} objects. It supports both linear and
circular genomes, and can detect ORFs on the sense (+) or both strands.
}
\details{
This method is optimized for prokaryotic genomes or transcript
sequences. Direct use for eukaryotic whole genomes is not suitable
due to the presence of splicing. See also \pkg{ORFik}'s \code{findMapORFs}.

Each FASTA header is treated independently, and the name (up to the
first space) is used as the \code{seqnames} in the returned \code{GRanges}
object. Circular genome support is included, and ORFs that span the
start/end boundary are handled.

Note: Ensure your FASTA file is valid and headers are formatted as
\verb{>name info}, with the name first and no hidden characters, as this
affects coordinate parsing.
}
\references{
Tjeldnes, H., Labun, K., Torres Cleuren, Y. et al.
ORFik: a comprehensive R toolkit for the analysis of translation.
BMC Bioinformatics 22, 336 (2021). DOI: 10.1186/s12859-021-04254-w
}
\author{
Haakon Tjeldnes et al. (original),
Chun Shen Lim (modification).
}
