% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{create_datasets}
\alias{create_datasets}
\title{Create DOU and DESeq2 datasets for differential translation analysis}
\usage{
create_datasets(
  count_table,
  condition_table,
  annotation,
  reduced_formula,
  emm_specs,
  deseq_formula,
  min_count = 1,
  stringent = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{count_table}{A matrix or data frame of raw counts. Columns must
match sample names in \code{condition_table}.}

\item{condition_table}{A data frame containing sample metadata. Must
include columns: \code{run}, \code{strategy}, \code{condition}, and
\code{replicate}.}

\item{annotation}{A \code{GRanges} object containing ORF annotations,
typically parsed from a flattened GTF or BED file.}

\item{reduced_formula}{A formula object specifying the reduced model
used for estimating marginal means (e.g., \code{~ condition + strategy}).}

\item{emm_specs}{A list of specifications for estimated marginal means
contrasts, typically generated using \code{emmeans::contrast()}.}

\item{deseq_formula}{A formula object specifying the design for DESeq2
modeling (e.g., \code{~ condition * strategy}).}

\item{min_count}{Integer specifying the minimum count threshold for
filtering ORFs. Default is \code{1}.}

\item{stringent}{Logical or \code{NULL}; determines the filtering strategy:
\describe{
\item{\code{TRUE}}{
Keep ORFs where all replicates in at least one condition pass
\code{min_count}.
}
\item{\code{FALSE}}{
Keep ORFs where all replicates in at least one condition-strategy
group pass \code{min_count}.
}
\item{\code{NULL}}{
Keep ORFs where total counts across all samples pass
\code{min_count}.
}
}}

\item{verbose}{Logical; if \code{TRUE}, prints progress and runtime
messages. Default is \code{TRUE}.}
}
\value{
A list containing:
\describe{
\item{\code{sumExp}}{
A \code{DOUData} object containing raw counts, metadata, and
filtering status.
}
\item{\code{dds}}{
A \code{DESeqDataSet} object prepared for differential
translation efficiency analysis.
}
}
}
\description{
This internal function constructs a \code{DOUData} object and a
\code{DESeqDataSet} object from raw count data, sample metadata, and ORF
annotations. It applies filtering based on count thresholds and singlet
status, prepares metadata for modeling, and stores formulas and contrast
specifications for downstream analysis.
}
\keyword{internal}
