% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{countReads}
\alias{countReads}
\title{Count reads from BAM files over genomic features}
\usage{
countReads(
  gr,
  bam_files,
  ignore.strand = list(single = TRUE, paired = FALSE),
  verbose = TRUE
)
}
\arguments{
\item{gr}{A \code{GRanges} object representing genomic features (e.g.,
ORFs).}

\item{bam_files}{Character vector. Paths to BAM files.}

\item{ignore.strand}{A named list with logical values for \code{single}
and \code{paired} indicating whether to ignore strand information.}

\item{verbose}{Logical. Whether to print progress messages.}
}
\value{
A matrix of read counts with features as rows and samples as
columns.
}
\description{
Uses \code{\link[GenomicAlignments]{summarizeOverlaps}} to count reads
overlapping genomic ranges, handling both single-end and paired-end
BAM files.
}
\examples{
\dontshow{if (requireNamespace("pasillaBamSubset", quietly = TRUE) && requireNamespace("GenomicRanges", quietly = TRUE)) withAutoprint(\{ # examplesIf}
library(GenomicRanges)
library(pasillaBamSubset)

bam_list <- c(untreated1_chr4(), untreated3_chr4())

gr <- GRanges(seqnames = "chr4", 
    ranges = IRanges(start = 233, end = 2300))
    
countReads(gr = gr, bam_files = bam_list)
\dontshow{\}) # examplesIf}
}
