% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{PostHoc-class}
\alias{PostHoc-class}
\alias{.PostHoc}
\title{The PostHoc class for DOTSeq}
\description{
The \code{PostHoc} class represents post hoc summaries derived from a
beta-binomial GLM/GLMM fitted to ORF-level data. It is also used to store
diagnostics and metadata for each ORF.

Objects of this class are typically created by the user-level function
\code{fitDOU()}, or manually using the \code{PostHoc()} constructor.
In the \pkg{DOTSeq} workflow, each ORF is assigned a \code{PostHoc}
object, which is stored in a \code{DataFrame} and embedded in the
\code{rowData} slot of a \code{SummarizedExperiment}.
}
\section{Slots}{

\describe{
\item{\code{type}}{A \code{character(1)} string indicating the model type.
Default is \code{"fitError"}. If the model is successfully fitted,
the type is typically \code{"glmmTMB"}.}

\item{\code{results}}{A \code{list} containing model results, parameters, and
test statistics.}

\item{\code{posthoc}}{An object of class \code{ANY} storing post hoc summary
objects (e.g., from \code{\link[emmeans]{emmeans}}).}
}}

\examples{
## Create a dummy PostHoc object
PostHocRes <- PostHoc(
    type = "glmmTMB",
    results = list(
        model_fit = list(aic = 96.03),
        tests = list(pvalue_best = 0.355)
    )
)
PostHocRes

}
