% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{DOTSeqDataSetsFromFeatureCounts}
\alias{DOTSeqDataSetsFromFeatureCounts}
\alias{DOTSeqDataSetsFromSummarizeOverlaps}
\title{Construct DOTSeqDatasets from featureCounts output for
Differential ORF Translation Analysis}
\usage{
DOTSeqDataSetsFromFeatureCounts(
  count_table,
  condition_table,
  flattened_gtf,
  flattened_bed,
  formula = ~condition * strategy,
  target = NULL,
  baseline = NULL,
  min_count = 1,
  stringent = TRUE,
  verbose = TRUE
)

DOTSeqDataSetsFromSummarizeOverlaps(
  count_table,
  condition_table,
  annotation,
  formula = ~condition * strategy,
  target = NULL,
  baseline = NULL,
  min_count = 1,
  stringent = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{count_table}{A dataframe of read counts with features as rows and
samples as columns. Generated from \code{\link{countReads}} based on
\code{\link[GenomicAlignments]{summarizeOverlaps}}.}

\item{condition_table}{Path to a sample metadata file or a data frame.
Must include columns: \code{run}, \code{strategy}, \code{condition},
\code{replicate}.}

\item{flattened_gtf}{Path to a flattened GFF/GTF file containing ORF
annotations.}

\item{flattened_bed}{Path to a flattened BED file with ORF annotations.}

\item{formula}{A formula object specifying the design.
Default is \code{~ condition * strategy}.}

\item{target}{Character string specifying the non-reference condition
level to extract the corresponding interaction term. Contrasted
against the baseline condition. Default is \code{NULL}.}

\item{baseline}{Character string specifying the desired reference
level. Default is \code{NULL}.}

\item{min_count}{Minimum count threshold for filtering ORFs.
Default is \code{1}.}

\item{stringent}{Logical or \code{NULL}; determines the filtering
strategy:
\describe{
\item{\code{TRUE}}{
Keep ORFs where all replicates in at least one condition
pass \code{min_count}.
}
\item{\code{FALSE}}{
Keep ORFs where all replicates in at least one
condition-strategy group pass \code{min_count}.
}
\item{\code{NULL}}{
Keep ORFs where total counts across replicates pass
\code{min_count}.
}
}}

\item{verbose}{Logical; if \code{TRUE}, prints progress messages.
Default is \code{TRUE}.}

\item{annotation}{A GRanges object with ORF level annotation,
typically obtained from \code{\link{getORFs}}.}
}
\value{
A \code{\link{DOTSeqDataSets-class}} object containing:
\describe{
\item{DOU}{
A \code{\link{DOUData-class}} object containing pre-filtered
raw counts (\code{assay} slot), sample metadata
(\code{colData} slot), and ORF-level annotation (\code{rowRanges})
used for modeling Differential ORF Usage (DOU).
}
\item{DTE}{
A \code{\link{DTEData-class}} object used for modeling
Differential Translation Efficiency (DTE). Stores all data above
except for \code{rowRanges}.
}
}

A \code{\link{DOTSeqDataSets-class}} object containing:
\describe{
\item{DOU}{
A \code{\link{DOUData-class}} object containing pre-filtered
raw counts (\code{assay} slot), sample metadata
(\code{colData} slot), and ORF-level annotation (\code{rowRanges})
used for modeling Differential ORF Usage (DOU).
}
\item{DTE}{
A \code{\link{DTEData-class}} object used for modeling
Differential Translation Efficiency (DTE). Stores all data above
except for \code{rowRanges}.
}
}
}
\description{
This function initialize and construct the
\code{\link{DOTSeqDataSets-class}} object. This includes loading count
and metadata tables, parsing ORF annotations, filtering ORFs based on
count thresholds, and preparing objects for downstream differential
translation analysis using beta-binomial and negative binomial GLM.

This function initialize and construct the
\code{\link{DOTSeqDataSets-class}} object. This includes loading count
and metadata tables, read a \code{GRanges} object with ORF-level
annotation, filtering ORFs based on count thresholds, and preparing
objects for downstream differential translation analysis using
beta-binomial and negative binomial GLM.
}
\examples{
# Read in count matrix, condition table, and annotation files
dir <- system.file("extdata", package = "DOTSeq")

cnt <- read.table(
    file.path(dir, "featureCounts.cell_cycle_subset.txt.gz"),
    header = TRUE,
    comment.char = "#"
)
names(cnt) <- gsub(".*(SRR[0-9]+).*", "\\\\1", names(cnt))

gtf <- file.path(dir, "gencode.v47.orf_flattened_subset.gtf.gz")
bed <- file.path(dir, "gencode.v47.orf_flattened_subset.bed.gz")

meta <- read.table(file.path(dir, "metadata.txt.gz"))
names(meta) <- c("run", "strategy", "replicate", "treatment", "condition")
cond <- meta[meta$treatment == "chx", ]
cond$treatment <- NULL

# Create a DOTSeqDataSets object
d <- DOTSeqDataSetsFromFeatureCounts(
    count_table = cnt,
    condition_table = cond,
    flattened_gtf = gtf,
    flattened_bed = bed
)

show(d)

}
\seealso{
\code{\link{DOTSeqDataSetsFromFeatureCounts}}

\code{\link{DOTSeqDataSetsFromFeatureCounts}}
}
