% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initiator.R
\name{sumExp2DNEA}
\alias{sumExp2DNEA}
\title{Initialize a DNEA from SummarizedExperiment}
\usage{
sumExp2DNEA(project_name, object, scaled_expression_assay, group_label_col)
}
\arguments{
\item{project_name}{A character string name for the experiment.}

\item{object}{a SummarizedExperiment object
object.}

\item{scaled_expression_assay}{A character string corresponding to
the assay in the summarizedExperiment object to use for analysis.
Defaults to log-scaling the count data if not provided.}

\item{group_label_col}{A character string corresponding to the
column in the sample metadata stored in the SummarizedExperiment object
to use as the group labels.}
}
\value{
A \code{\link[=DNEA-class]{DNEA}} object.
}
\description{
This function takes as input a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment-class}}
object non-transformed in order to initiate a
\code{\link[=DNEA-class]{DNEA}} object. Differential expression analysis
is performed using a student's T-test and Benjamini-Hochberg
for multiple-testing corrections. Diagnostic testing is done
on the input data by checking the minimum eigen value and
condition number of the expression data for each
experimental condition.
\subsection{IMPORTANT:}{

Special attention should be given to the diagnostic criteria that is
output. The minimum eigen value and condition number are calculated for
the whole data set as well as for each condition to determine mathematic
stability of the data set and subsequent results from a GGM model. More
information about interpretation can be found in the
\strong{\emph{Details}} section below.
}
}
\details{
\subsection{Diagnostics Motivation}{

Negative or zero eigenvalues in a data set can represent
instability in that portion of the matrix, thereby invalidating
parametric statistical methods and creating unreliable results. In this
function, the minimum eigenvalue of the data set is calculated by first
creating a pearson correlation matrix of the data. Instability may then
occur for a number of reasons, but one common cause is highly correlated
features (in the positive and negative direction). \cr

Regularization often takes care of this problem by arbitrarily
selecting one of the variables in a highly correlated group and removing
the rest. We have developed DNEA to be very robust in situations where
\strong{\emph{p >> n}} by optimizing the model via several regularization
steps (\emph{please see} \code{\link{BICtune}} \emph{and}
\code{\link{stabilitySelection}}) that may handle such problems without
intervention, however, the user can also pre-emptively collapse
highly-correlated features into a single group via
\code{\link{aggregateFeatures}}.
}

\subsection{Benefits of Feature Aggregation}{

When your dataset contains highly correlated features, we recommend
aggregating features into related groups - such as highly-correlated
features of a given class of molecules (ie. many fatty acids,
carnitines, etc.) - because the user then has more control over which
variables are included in the model. Without collapsing, the model
regularization may result in one of the features within a class being
included and some or all of the remaining features being removed. By
collapsing first, you retain the signal from all of the features in the
collapsed group and also have information pertaining to which features
are highly correlated and will therefore have similar
feature-feature associations.
}
}
\examples{
#load example data from airway package
library(airway)
data(airway)

airway <- airway[1:50,]
airway <- airway[rowSums(SummarizedExperiment::assays(airway)$counts) > 5, ]
DNEA <- sumExp2DNEA(project_name = "airway",
                       object = airway,
                       group_label_col = "dex")

}
\seealso{
\code{\link{BICtune}}, \code{\link{stabilitySelection}},
\code{\link{createDNEAobject}}
}
\author{
Christopher Patsalis
}
