% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{selectionResults}
\alias{selectionResults}
\alias{selectionResults,DNEA-method}
\title{Access and set the edge selection results from stabilitySelection()}
\usage{
selectionResults(x)

\S4method{selectionResults}{DNEA}(x)
}
\arguments{
\item{x}{A \code{\link{DNEA}} object.}
}
\value{
A \code{\link{DNEA}} object after filling the
selection_results section of the stable_networks slot.
}
\description{
The function takes as input a \code{\link{DNEA}} object and returns
an \emph{m x n} matrix of selection results for every possible network
edge calculated during \code{\link{stabilitySelection}}.
}
\examples{
#dnw is a DNEA with the results generated for the example data
#accessed by running data(TEDDY) in the console. The workflow
#for this data can be found in the vignette accessed by
#running browseVignettes("DNEA") in the console.
data(dnw)

selectionResults(dnw)
}
\seealso{
\code{\link{stabilitySelection}},\code{\link{selectionProbabilities}}
}
\author{
Christopher Patsalis
}
