% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{networkGroupIDs}
\alias{networkGroupIDs}
\alias{networkGroupIDs<-}
\alias{networkGroupIDs,DNEA-method}
\title{Access and set the experimental group labels}
\usage{
networkGroupIDs(x)

networkGroupIDs(x) <- value

\S4method{networkGroupIDs}{DNEA}(x)
}
\arguments{
\item{x}{A \code{\link{DNEA}} object.}

\item{value}{a character string name corresponding to a column
name of the sample metadata data frame.}
}
\value{
A vector of the unique condition labels.
}
\description{
This function accesses the experimental group labels for
each sample stored in the metadata slot of a
\code{\link{DNEA}} object.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

networkGroupIDs(dnw)
}
\seealso{
\code{\link{includeMetadata}}
}
\author{
Christopher Patsalis
}
