% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{metaData}
\alias{metaData}
\alias{metaData,DNEA-method}
\title{Retrieve metadata stored in a DNEA}
\usage{
metaData(x, type)

\S4method{metaData}{DNEA}(x, type = c("samples", "features"))
}
\arguments{
\item{x}{A \code{\link{DNEA}} object.}

\item{type}{A character string indicating the type
of metadata to access. Can be "sample" or "feature".}
}
\value{
A data frame of the indicated metadata
}
\description{
This function retrieves the specified metadata stored
in the metadata slot of the
\code{\link{DNEA}} object.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

metaData(dnw, type = "sample")
}
\seealso{
\code{\link{includeMetadata}}

\code{\link{createDNEAobject}}, \code{\link{includeMetadata}}

\code{\link{includeMetadata}}
}
\author{
Christopher Patsalis
}
