% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/all-methods.R
\name{diagnostics}
\alias{diagnostics}
\alias{diagnostics,DNEA-method}
\alias{diagnostics,DNEAinputSummary-method}
\title{Retrieve the diagnostic values for the input expression data}
\usage{
diagnostics(x)

\S4method{diagnostics}{DNEA}(x)

\S4method{diagnostics}{DNEAinputSummary}(x)
}
\arguments{
\item{x}{\code{\link{DNEA}} or
\code{DNEAinputSummary} object.}
}
\value{
Returns the diagnostic values for
the input expression data.
}
\description{
This function retrieves the diagnostic values calculated
for the input expression data by the
\code{\link{createDNEAobject}} function.
}
\examples{
#load example data
data(TEDDY)
data(T1Dmeta)

#make sure metadata and expression data are in same order
T1Dmeta <- T1Dmeta[colnames(TEDDY),]

#create group labels
group_labels <- T1Dmeta$group
names(group_labels) <- rownames(T1Dmeta)

#initiate DNEA object
dnw <- createDNEAobject(project_name = "test", expression_data = TEDDY,
                            group_labels = group_labels)

diagnostics(dnw)
}
\seealso{
\code{\link{createDNEAobject}}, \code{\link{aggregateFeatures}}
}
\author{
Christopher Patsalis
}
