% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNAfusion_functions.R
\name{find_variants}
\alias{find_variants}
\title{Detect the variants of ALK-EML4}
\usage{
find_variants(file, genome = "hg38")
}
\arguments{
\item{file}{The name of the file which the data are to be read from.}

\item{genome}{\code{character} representing the reference genome.
Can be either "hg38" or "hg19". Default="hg38".}
}
\value{
A \code{dataframe}of the ALK-EML4 variant is returned.
If no variant is detected, "No ALK-EML4 was detected" is returned.
If the variant is not classified a \code{list} with identified introns with
breakpoints is returned.
If the breakpoint could not be identified in either of the genes a \code{list}
with identified introns with breakpoints is returned.
}
\description{
This function identifies ALK-EML4 variants using the intron of the breakpoint
of EML4
}
\examples{
H3122_bam <- system.file("extdata",
"H3122_EML4.bam",
package="DNAfusion")
HCC827_bam <-  system.file("extdata",
"HCC827_EML4.bam",
package="DNAfusion")
find_variants(file=H3122_bam,genome="hg38")
find_variants(file=HCC827_bam,genome="hg38")
}
