% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNAfusion_functions.R
\name{break_position}
\alias{break_position}
\title{EML4-ALK breakpoint}
\usage{
break_position(reads, gene, genome = "hg38")
}
\arguments{
\item{reads}{\code{GAlignments} object returned by \code{EML4_ALK_detection()}.}

\item{gene}{\verb{Character string} representing the gene.
Can be either "ALK" or "EML4".}

\item{genome}{\verb{Character string} representing the reference genome.
Can be either "hg38" or "hg19". Default="hg38".}
}
\value{
If EML4-ALK is detected, it returns a \code{table} of genomic positions
with the number of corresponding reads for each sequence.
If no spanning reads in EML4 or ALK is detected
an empty \code{GAlignments} object is returned. If no EML4-ALK is detected
"No EML4-ALK was detected" is returned.
}
\description{
This function identifies the genomic position in EML4 or ALK,
where the breakpoint has happened.
}
\examples{
H3122_bam <- system.file("extdata",
"H3122_EML4.bam",
package="DNAfusion")
HCC827_bam <-  system.file("extdata",
"HCC827_EML4.bam",
package="DNAfusion")

break_position(EML4_ALK_detection(file=H3122_bam,
                                    genome="hg38",
                                    mates=2),gene="EML4",genome="hg38")
break_position(EML4_ALK_detection(file=H3122_bam,
                                    genome="hg38",
                                    mates=2),gene="ALK",genome="hg38")
break_position(EML4_ALK_detection(file=HCC827_bam,
                                    genome="hg38",
                                    mates=2),gene="EML4",genome="hg38")
break_position(EML4_ALK_detection(file=HCC827_bam,
                                    genome="hg38",
                                    mates=2),gene="ALK",genome="hg38")
}
