% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNAfusion_functions.R
\name{ALK_sequence}
\alias{ALK_sequence}
\title{Identification of ALK breakpoint bases}
\usage{
ALK_sequence(reads, basepairs = 20, genome = "hg38")
}
\arguments{
\item{reads}{\code{GAlignments} returned by \code{EML4_ALK_detection()}.}

\item{basepairs}{\code{integer}, number of basepairs identified
from the EML4-ALK fusion. Default=20.}

\item{genome}{\verb{Character string} representing the reference genome.
Can be either "hg38" or "hg19". Default="hg38".}
}
\value{
If EML4-ALK is detected, returns a \code{table} of identified
ALK basepairs with the number of corresponding reads for each sequence.
If no spanning reads in ALK is detected an empty \code{GAlignments}
object is returned.If no EML4-ALK is detected "No EML4-ALK was detected"
is returned.
}
\description{
This function identifies the basepairs following the ALK breakpoint.
}
\examples{
H3122_bam <- system.file("extdata",
"H3122_EML4.bam",
package="DNAfusion")
HCC827_bam <-  system.file("extdata",
"HCC827_EML4.bam",
package="DNAfusion")

ALK_sequence(EML4_ALK_detection(file=H3122_bam,
                                    genome="hg38",
                                    mates=2),
                basepairs=20,
                genome="hg38")
ALK_sequence(EML4_ALK_detection(file=HCC827_bam,
                                    genome="hg38",
                                    mates=2),
                basepairs=20,
                genome="hg38")
}
