% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_random_combinations.R
\name{get_random_combinations}
\alias{get_random_combinations}
\title{Get a large set of compatible combinations.}
\usage{
get_random_combinations(index_df, mplex_level, platform)
}
\arguments{
\item{index_df}{A dataframe containing barcodes identifiers, corresponding
DNA sequences along with GC content and presence of homopolymers.}

\item{mplex_level}{The number at which the barcodes will be multiplexed.
Illumina recommends to not multiplex more than 96 libraries.}

\item{platform}{An integer representing the number of channels (1, 2, 4)
of the desired Illumina platform: 1 for iSeq; 2 for NextSeq, NovaSeq,
MiniSeq; 4 for HiSeq and MiSeq. 0 represents any other platform than
Illumina.}
}
\value{
A matrix containing the identifiers of compatible barcode combinations.
}
\description{
Finds a randomly generated set of at most 1000 combinations
of compatible barcodes.
}
\details{
This function is suited if the total number of possible combinations is too
high for an exhaustive search to be possible in a reasonable amount of time.
}
\examples{
get_random_combinations(DNABarcodeCompatibility::IlluminaIndexes, 3, 4)


}
\seealso{
\code{\link{get_all_combinations}}
}
