% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localProfile.R
\name{plotLocalMethylationProfile}
\alias{plotLocalMethylationProfile}
\title{Plot local methylation profile}
\usage{
plotLocalMethylationProfile(
  methylationData1,
  methylationData2,
  region,
  DMRs = NULL,
  conditionsNames = NULL,
  gff = NULL,
  windowSize = 150,
  context = "CG",
  labels = NULL,
  col = NULL,
  main = "",
  plotMeanLines = TRUE,
  plotPoints = TRUE
)
}
\arguments{
\item{methylationData1}{the methylation data in condition 1
(see \code{\link{methylationDataList}}).}

\item{methylationData2}{the methylation data in condition 2
(see \code{\link{methylationDataList}}).}

\item{region}{a \code{\link{GRanges}} object with the region where to plot
the high resolution profile.}

\item{DMRs}{a \code{\link{GRangesList}} object or a list with the list of
DMRs (see \code{\link{computeDMRs}} or \code{\link{filterDMRs}}.}

\item{conditionsNames}{the names of the two conditions. This will be used to
plot the legend.}

\item{gff}{a \code{\link{GRanges}} object with all elements usually imported
from a GFF3 file. The gff file needs to have an metafield \code{"type"}. Only
the elements of type  \code{"gene"}, \code{"exon"} and
\code{"transposable_element"} are plotted. Genes are represented as
horizontal black lines, exons as a black rectangle and transposable elements
as a grey rectangle. The elements are plotted on the corresponding strand
(\code{+} or \code{-}).}

\item{windowSize}{the size of the triangle base used to smooth the average
methylation profile.}

\item{context}{the context in which the DMRs are computed (\code{"CG"},
\code{"CHG"} or \code{"CHH"}).}

\item{labels}{a \code{vector} of \code{character} used to add a subfigure
characters to the plot. If \code{NULL} nothing is added.}

\item{col}{a \code{character} vector with the colors. It needs to contain a
minimum of \code{4 length(DMRs)} colors. If not or if \code{NULL}, the
defalut colors will be used.}

\item{main}{a \code{character} with the title of the plot}

\item{plotMeanLines}{a \code{logical} value indicating whether to plot the
mean lines or not.}

\item{plotPoints}{a \code{logical} value indicating whether to plot the
points or not.}
}
\value{
Invisibly returns \code{NULL}
}
\description{
This function plots the methylation profile at one locus for the bisulfite
sequencing data.The points on the graph represent methylation proportion of
individual cytosines, their colour which sample they belong to and the
intesity of the the colour how many reads that particular cytosine had. This
means that darker colors indicate stronger evidence that the corresponding
cytosine has the corresponding methylation proportion, while lighter colors
indicate a weaker evidence. The solid lines represent the smoothed profiles
and the intensity of the line the coverage at the corresponding position
(darker colors indicate more reads while lighter ones less reads). The boxes
on top represent the DMRs, where a filled box will represent a DMR which
gained methylation while a box with a pattern represent a DMR that lost
methylation. The DMRs need to have a metadafield \code{"regionType"} which
can be either \code{"gain"} (where there is more methylation in condition 2
compared to condition 1) or \code{"loss"} (where there is less methylation in
condition 2 compared to condition 1). In case this metadafield is missing all
DMRs are drawn using a filled box. Finally, we also allow annotation of the
DNA sequence. We represent by a black boxes all the exons, which are joined
by a horizontal black line, thus, marking the full body of the gene. With
grey boxes we mark the transposable elements. Both for genes and transposable
elements we plot them over a mid line if they are on the positive strand and
under the mid line if they are on the negative strand.
}
\examples{

# load the methylation data
data(methylationDataList)
# load the gene annotation data
data(GEs)

#select the genes
genes <- GEs[which(GEs$type == "gene")]

# the coordinates of the area to be plotted
chr3Reg <- GRanges(seqnames = Rle("Chr3"), ranges = IRanges(510000,530000))

# load the DMRs in CG context
data(DMRsNoiseFilterCG)

DMRsCGlist <- list("noise filter"=DMRsNoiseFilterCG)


# plot the CG methylation
par(mar=c(4, 4, 3, 1)+0.1)
par(mfrow=c(1,1))
plotLocalMethylationProfile(methylationDataList[["WT"]],
                           methylationDataList[["met1-3"]], chr3Reg,
                           DMRsCGlist, c("WT", "met1-3"), GEs,
                           windowSize=100, main="CG methylation")

}
\author{
Nicolae Radu Zabet
}
