% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DF-join.R
\name{inner_join.DataFrame}
\alias{inner_join.DataFrame}
\title{Mutating joins}
\usage{
\method{inner_join}{DataFrame}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = NULL
)
}
\arguments{
\item{x}{a \code{DataFrame}}

\item{y}{a \code{DataFrame} or \code{data.frame}}

\item{by}{columns to use for joining the objects. If \code{NULL}, the function
will look for common columns.}
}
\value{
a \code{DataFrame}
}
\description{
Mutating joins
}
\examples{
library(dplyr)
library(S4Vectors)
da <- starwars[, c("name", "mass", "species")][1:10, ]
db <- starwars[, c("name", "homeworld")]

Da <- as(da, "DataFrame")
Db <- as(db, "DataFrame")

Res_inner <- inner_join(Da, Db[1:3, ])

}
\keyword{internal}
