% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFplyr-package.R
\docType{package}
\name{DFplyr-package}
\alias{DFplyr}
\alias{DFplyr-package}
\title{Treat a \code{S4Vectors::DataFrame} as a \code{dplyr} data source}
\arguments{
\item{x}{A \code{S4Vectors::DataFrame} object}
}
\description{
Add \pkg{dplyr} compatibility to \code{S4Vectors::DataFrame}
for use with a selection of \pkg{dplyr} verbs.
}
\examples{
library(S4Vectors)
library(dplyr)

d <- as(mtcars, "DataFrame")

mutate(d, newvar = cyl + hp)

mutate_at(d, vars(starts_with("c")), ~ .^2)

group_by(d, cyl, am) \%>\%
    tally(gear)

count(d, gear, am, cyl)

select(d, am, cyl)

select(d, am, cyl) \%>\%
    rename2(foo = am)

arrange(d, desc(hp))

rbind(DataFrame(mtcars[1, ], row.names = "MyCar"), d) \%>\%
    distinct()

filter(d, am == 0)

slice(d, 3:6)
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/jonocarroll/DFplyr}
  \item Report bugs at \url{https://github.com/jonocarroll/DFplyr/issues}
}

}
\author{
\strong{Maintainer}: Jonathan Carroll \email{rpkg@jcarroll.com.au} (\href{https://orcid.org/0000-0002-1404-5264}{ORCID})

Other contributors:
\itemize{
  \item Pierre-Paul Axisa [contributor]
}

}
