% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{filterCounts}
\alias{filterCounts}
\title{filter count data}
\usage{
filterCounts(object, maxCountFile, countThresh, nsamples)
}
\arguments{
\item{object}{\code{DESeqDataSet}, see \code{\link{DESeqDataSetFromSlidingWindows}}}

\item{maxCountFile}{\code{character} file name/path to max count matrix}

\item{countThresh}{\code{numeric} max count threshold}

\item{nsamples}{\code{numeric} number of samples where the max count value must be\cr
>= countThresh}
}
\value{
DESeq object
}
\description{
In addition to count data matrix, htseq-clip also creates a max count matrix.\cr
For each window, this file contains the maximum crosslink site count (height)  calculated \cr
per nucleotide. This function uses this file to filter the count data file instead of the \cr
default prefiltering on \code{rowSums}. Windows failing the threshold \cr
\code{rowSums(maxWindowCount>=countThresh)>=nSamples} will be removed from the object.
}
