% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extractRegions}
\alias{extractRegions}
\title{extract significant regions}
\usage{
extractRegions(
  windowRes,
  padjCol = "padj",
  padjThresh = 0.05,
  log2FoldChangeCol = "log2FoldChange",
  log2FoldChangeThresh = 1,
  start0based = TRUE
)
}
\arguments{
\item{windowRes}{\code{data.frame}, output from \code{\link{resultsDEWSeq}}}

\item{padjCol}{\code{character}, name of the adjusted pvalue column
(default: padj)}

\item{padjThresh}{\code{numeric}, threshold for p-adjusted value
(default: 0.05)}

\item{log2FoldChangeCol}{\code{character}, name of the log2foldchange column
(default: log2FoldChange)}

\item{log2FoldChangeThresh}{\code{numeric}, threshold for log2foldchange value
(default:1)}

\item{start0based}{\code{logical}, TRUE (default) or FALSE.
If TRUE, then the start positions in \code{windowRes}
is  considered to be 0-based}
}
\value{
data.frame
}
\description{
extract significant windows from output of
    \code{\link{resultsDEWSeq}} using the supplied padj and
     log2FoldChange cut-offs and merge these significant windows
      to regions and create the following columns for each
       significant region:
\itemize{
\item \code{padj_min}: min. padj value in the region
\item \code{padj_mean}: average padj value in the region
\item \code{padj_max}: max. padj value in the region
\item \code{log2FoldChange_min}: min. log 2 fold change in the region
\item \code{log2FoldChange_mean}: average log 2 fold change in the region
\item \code{log2FoldChange_max}: max. log 2 fold change in the region
}
}
\details{
The output data.frame from this function will have the following columns:
\itemize{
 \item \code{chromosome}: chromosome name
 \item \code{regionStartId}: \code{unique_id} of the left most window,
 where an enriched region begins
 \item \code{region_begin}: starting position of the enriched region
 \item \code{region_end}: ending position of the enriched region
 \item \code{strand}: strand info
 \item \code{windows_in_region}: total number of windows
  that make up the enriched region
 \item \code{region_length}: length of the enrched region
 \item \code{gene_id}: gene id
 \item \code{gene_name}: gene name
 \item \code{gene_type}: gene type annotation
 \item \code{gene_region}: gene region
 \item \code{Nr_of_region}: number of the current region
 \item \code{Total_nr_of_region}: total number of regions
 \item \code{window_number}: window number
 \item \code{padj_min}: min. padj value in the region
 \item \code{padj_mean}: average padj value in the region
 \item \code{padj_max}: max. padj value in the region
 \item \code{log2FoldChange_min}: min. log 2 fold change in the region
 \item \code{log2FoldChange_max}: max. log 2 fold change in the region
 \item \code{log2FoldChange_mean}: average log 2 fold change in the region
}
}
\examples{

data("slbpWindows")
# using default cut-off thresholds,
# 'pSlidingWindows.adj' padj value columns
slbpRegions <- extractRegions(slbpWindows,
padjCol = 'pSlidingWindows.adj')

}
