% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{DESeqDataSetFromSlidingWindows}
\alias{DESeqDataSetFromSlidingWindows}
\title{create DESeq data object}
\usage{
DESeqDataSetFromSlidingWindows(
  countData,
  colData,
  annotObj,
  design,
  tidy = FALSE,
  ignoreRank = FALSE,
  start0based = TRUE
)
}
\arguments{
\item{countData}{\code{data.frame} or \code{matrix}, sliding window count data}

\item{colData}{\code{DataFrame} or \code{data.frame}, phenotype data,
see \code{\link[DESeq2:DESeqDataSet]{DESeqDataSet}}}

\item{annotObj}{\code{data.frame} or \code{character}, can either be a data.frame or a file name,
see details}

\item{design}{\code{formula} or \code{matrix}, design of the experiment,
see \code{\link[DESeq2:DESeqDataSet]{DESeqDataSet}}}

\item{tidy}{\code{logical}, If TRUE, first column is of countData is treated as rownames
(defalt: FALSE), see \code{\link[DESeq2:DESeqDataSet]{DESeqDataSet}}}

\item{ignoreRank}{\code{logical}, ignore rank, see \code{\link[DESeq2:DESeqDataSet]{DESeqDataSet}}}

\item{start0based}{\code{logical}, TRUE (default) or FALSE.
If TRUE, then the start positions in \code{annotObj} is  considered to be 0-based}
}
\value{
DESeq object
}
\description{
create DESeq data object from sliding window counts,
phenotype data and annotation data
}
\details{
If \code{annotObj} is a file name, the input file MUST be <TAB> separated, and supports reading in .gz files. \cr
If \code{annotObj} is a data.frame, \code{colnames(annotObj)} MUST not be empty.\cr
This function checks for the following columns after reading in the file or on data.frame:
\itemize{
  \item \code{chromosome}: chromosome name
  \item \code{unique_id}: unique id of the window, \code{rownames(object)} must match this column
  \item \code{begin}: window start co-ordinate, see parameter \code{start0based}
  \item \code{end}: window end co-ordinate
  \item \code{strand}: strand
  \item \code{gene_id}: gene id
  \item \code{gene_name}: gene name
  \item \code{gene_type}: gene type annotation
  \item \code{gene_region}: gene region
  \item \code{Nr_of_region}: number of the current region
  \item \code{Total_nr_of_region}: total number of regions
  \item \code{window_number}: window number
}

This function creates a \code{\link[DESeq2:DESeqDataSet]{DESeqDataSet}} using supplied countData, phenotype data
and annotation data. The chromosomal locations and annotations of the sliding windows
(parsed from \code{annotObj}) can be accessed from the returned object using: \code{rowRanges(object)}
}
\examples{

data("SLBP_K562_w50s20")
slbpDat <- counts(SLBP_K562_w50s20)
phenoDat <- DataFrame(conditions=as.factor(c(rep('IP',2),'SMI')),
row.names = colnames(slbpDat))
phenoDat$conditions <- relevel(phenoDat$conditions,ref='SMI')
annotDat <- as.data.frame(rowRanges(SLBP_K562_w50s20))
# by default chromsome column is 'seqnames'
# and begin co-ordinate column is 'start'
# rename these columns
colnames(annotDat)[1:2] <- c('chromosome','begin')
slbpDds <- DESeqDataSetFromSlidingWindows(countData = slbpDat,
colData = phenoDat,annotObj = annotDat,design=~conditions)

}
