% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{cutGRangesPerChromosome}
\alias{cutGRangesPerChromosome}
\title{cutGRangesPerChromosome}
\usage{
cutGRangesPerChromosome(GRanges)
}
\arguments{
\item{GRanges}{a GRanges object.}
}
\value{
a named list of GRanges, one for each chromosome.
}
\description{
takes in input a GRanges object, producing a LIST of
GRanges, one for each chromosome.
}
\examples{
library("GenomicRanges")
gr <- GRanges(
        seqnames=Rle(c("chr1", "chr2", "chr1", "chr3"), c(1, 3, 2, 4)),
        ranges=IRanges(1:10, end=10),
        strand=Rle(strand(c("-", "+", "*", "+", "-")), c(1, 2, 2, 3, 2)),
        seqlengths=c(chr1=11, chr2=12, chr3=13))
(grchrlist <- cutGRangesPerChromosome(gr))
}
