% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_corr_matrix.R
\name{corrMatrixD_HC}
\alias{corrMatrixD_HC}
\title{Displays a correlation matrix of the quantitative data of the
\code{Biobase::exprs()} table.}
\usage{
corrMatrixD_HC(object, samplesData = NULL, rate = 0.5, showValues = TRUE)
}
\arguments{
\item{object}{The result of the \code{cor} function.}

\item{samplesData}{A dataframe in which lines correspond to samples and
columns to the meta-data for those samples.}

\item{rate}{The rate parameter to control the exponential law for
the gradient of colors}

\item{showValues}{xxx}
}
\value{
A colored correlation matrix
}
\description{
Displays a correlation matrix of the quantitative data of the
\code{Biobase::exprs()} table.
}
\examples{
data(Exp1_R25_pept, package="DAPARdata")
qData <- Biobase::exprs(Exp1_R25_pept)
samplesData <- Biobase::pData(Exp1_R25_pept)
res <- cor(qData, use = "pairwise.complete.obs")
corrMatrixD_HC(res, samplesData)

}
\author{
Samuel Wieczorek
}
