% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots_boxplot.R
\name{boxPlotD_HC}
\alias{boxPlotD_HC}
\title{Builds a boxplot from a dataframe using the package \code{highcharter}}
\usage{
boxPlotD_HC(
  obj,
  conds,
  keyId = NULL,
  legend = NULL,
  pal = NULL,
  subset.view = NULL
)
}
\arguments{
\item{obj}{Numeric matrix}

\item{conds}{xxx}

\item{keyId}{xxxx}

\item{legend}{A vector of the conditions (one condition per sample).}

\item{pal}{A basis palette for the boxes which length must be equal
to the number of unique conditions in the dataset.}

\item{subset.view}{A vector of index indicating which rows to highlight}
}
\value{
A boxplot
}
\description{
Builds a boxplot from a dataframe using the package \code{highcharter}
}
\examples{
data(Exp1_R25_prot, package="DAPARdata")
obj <- Exp1_R25_prot
conds <- legend <- Biobase::pData(obj)$Condition
key <- "Protein_IDs"
pal <- ExtendPalette(length(unique(conds)))
boxPlotD_HC(obj, conds, key, legend, pal, seq_len(10))
}
\author{
Samuel Wieczorek, Anais Courtier, Enora Fremy
}
