% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacell.R
\name{BuildMetaCell}
\alias{BuildMetaCell}
\title{Builds cells metadata}
\usage{
BuildMetaCell(from, level, qdata = NULL, conds = NULL, df = NULL)
}
\arguments{
\item{from}{A string which is the name of the software from which the data
are. Available values are 'maxquant', 'proline' and 'DIA-NN'}

\item{level}{xxx}

\item{qdata}{An object of class \code{MSnSet}}

\item{conds}{xxx}

\item{df}{A list of integer xxxxxxx}
}
\value{
xxxxx
}
\description{
This function the cells metadata info base on the origin of identification
for entities.
There are actually two different type of origin which are managed by DAPAR:
- "Maxquant-like" info which is represented by strings/tags,
- Proline-like where the info which is used is an integer
}
\examples{
file <- system.file("extdata", "Exp1_R25_pept.txt", package = "DAPARdata")
data <- read.table(file, header = TRUE, sep = "\t", stringsAsFactors = FALSE)
metadataFile <- system.file("extdata", "samples_Exp1_R25.txt",
    package = "DAPARdata")
metadata <- read.table(metadataFile,
    header = TRUE, sep = "\t", as.is = TRUE,
    stringsAsFactors = FALSE)
conds <- metadata$Condition
qdata <- data[, seq.int(from = 56, to = 61)]
df <- data[, seq.int(from = 43, to = 48)]
df <- BuildMetaCell(
    from = "maxquant", level = "peptide", qdata = qdata,
    conds = conds, df = df)
df <- BuildMetaCell(
    from = "proline", level = "peptide", qdata = qdata,
    conds = conds, df = df)

}
\author{
Samuel Wieczorek
}
