% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methyl_MDS_plot.R
\name{methyl_MDS_plot}
\alias{methyl_MDS_plot}
\title{Multidimensional scaling plot of distances between methylation 
proportions (beta values)}
\usage{
methyl_MDS_plot(x, group, top = 1000, coverage = 5, adj = 0.02, pointSize = 4)
}
\arguments{
\item{x}{\code{RangedSummarizedExperiment}, output from
\code{calc_derivedasm} or \code{calc_asm}.}

\item{group}{Vector of group or any other labels, same length as number of
samples.}

\item{top}{Number of top CpG sites used to calculate pairwise distances.}

\item{coverage}{Minimum number of reads covering a CpG site on each allele.
Default = 5.}

\item{adj}{Text adjustment in y-axis. Default = 0.2.}

\item{pointSize}{Default = 4.}
}
\value{
Two-dimensional MDS plot.
}
\description{
Same as \code{\link{plotMDS}}, except for an arc-sine transformation of the
methylation proportions.
}
\examples{
data(readtuples_output)
ASM <- calc_asm(readtuples_output)
grp <- factor(c(rep('CRC',3),rep('NORM',2)), levels = c('NORM', 'CRC'))
methyl_MDS_plot(ASM, grp)

}
